/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.commons.lang3.ArrayUtils;
import org.jclouds.compute.options.TemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboundPortsOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(InboundPortsOption.class);

    InboundPortsOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        int[] inboundPorts = this.toIntPortArray(v);
        if (LOG.isDebugEnabled()) {
            LOG.debug("opening inbound ports {} for cloud/type {}", (Object)Arrays.toString(inboundPorts), t.getClass());
        }
        t.inboundPorts(inboundPorts);
    }

    private int[] toIntPortArray(Object v) {
        PortRange portRange = PortRanges.fromIterable(Collections.singletonList(v));
        return ArrayUtils.toPrimitive((Integer[])((Integer[])Iterables.toArray((Iterable)portRange, Integer.class)));
    }
}

