/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.PodSchedulingContextSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSchedulingContextSpecFluent<A extends PodSchedulingContextSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> potentialNodes = new ArrayList<String>();
    private String selectedNode;
    private Map<String, Object> additionalProperties;

    public PodSchedulingContextSpecFluent() {
    }

    public PodSchedulingContextSpecFluent(PodSchedulingContextSpec instance) {
        PodSchedulingContextSpec podSchedulingContextSpec = instance = instance != null ? instance : new PodSchedulingContextSpec();
        if (instance != null) {
            this.withPotentialNodes(instance.getPotentialNodes());
            this.withSelectedNode(instance.getSelectedNode());
            this.withPotentialNodes(instance.getPotentialNodes());
            this.withSelectedNode(instance.getSelectedNode());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPotentialNodes(int index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.add(index, item);
        return (A)((Object)this);
    }

    public A setToPotentialNodes(int index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.set(index, item);
        return (A)((Object)this);
    }

    public A addToPotentialNodes(String ... items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPotentialNodes(Collection<String> items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPotentialNodes(String ... items) {
        if (this.potentialNodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.potentialNodes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPotentialNodes(Collection<String> items) {
        if (this.potentialNodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.potentialNodes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPotentialNodes() {
        return this.potentialNodes;
    }

    public String getPotentialNode(int index) {
        return this.potentialNodes.get(index);
    }

    public String getFirstPotentialNode() {
        return this.potentialNodes.get(0);
    }

    public String getLastPotentialNode() {
        return this.potentialNodes.get(this.potentialNodes.size() - 1);
    }

    public String getMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPotentialNodes(List<String> potentialNodes) {
        if (potentialNodes != null) {
            this.potentialNodes = new ArrayList<String>();
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        } else {
            this.potentialNodes = null;
        }
        return (A)((Object)this);
    }

    public A withPotentialNodes(String ... potentialNodes) {
        if (this.potentialNodes != null) {
            this.potentialNodes.clear();
            this._visitables.remove((Object)"potentialNodes");
        }
        if (potentialNodes != null) {
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPotentialNodes() {
        return this.potentialNodes != null && !this.potentialNodes.isEmpty();
    }

    public String getSelectedNode() {
        return this.selectedNode;
    }

    public A withSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
        return (A)((Object)this);
    }

    public boolean hasSelectedNode() {
        return this.selectedNode != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSchedulingContextSpecFluent that = (PodSchedulingContextSpecFluent)((Object)o);
        if (!Objects.equals(this.potentialNodes, that.potentialNodes)) {
            return false;
        }
        if (!Objects.equals(this.selectedNode, that.selectedNode)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.potentialNodes, this.selectedNode, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.potentialNodes != null && !this.potentialNodes.isEmpty()) {
            sb.append("potentialNodes:");
            sb.append(this.potentialNodes + ",");
        }
        if (this.selectedNode != null) {
            sb.append("selectedNode:");
            sb.append(this.selectedNode + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

