/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.features;

import com.google.common.annotations.Beta;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.Rule;
import org.jclouds.openstack.neutron.v2.domain.Rules;
import org.jclouds.openstack.neutron.v2.domain.SecurityGroup;
import org.jclouds.openstack.neutron.v2.domain.SecurityGroups;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyRulesFallback;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptySecurityGroupsFallback;
import org.jclouds.openstack.neutron.v2.functions.ParseRules;
import org.jclouds.openstack.neutron.v2.functions.ParseSecurityGroups;
import org.jclouds.openstack.neutron.v2.functions.RulesToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.SecurityGroupsToPagedIterable;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Beta
public interface SecurityGroupApi {
    @Path(value="/security-groups")
    @Named(value="security-group:list")
    @GET
    @ResponseParser(value=ParseSecurityGroups.class)
    @Transform(value=SecurityGroupsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<SecurityGroup> listSecurityGroups();

    @Path(value="/security-groups")
    @Named(value="security-group:list")
    @GET
    @ResponseParser(value=ParseSecurityGroups.class)
    @Fallback(value=EmptySecurityGroupsFallback.class)
    public SecurityGroups listSecurityGroups(PaginationOptions var1);

    @Path(value="/security-groups/{id}")
    @Named(value="security-group:get")
    @GET
    @SelectJson(value={"security_group"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SecurityGroup getSecurityGroup(@PathParam(value="id") String var1);

    @Path(value="/security-groups")
    @Named(value="secuity-group:create")
    @POST
    @SelectJson(value={"security_group"})
    public SecurityGroup create(@WrapWith(value="security_group") SecurityGroup.CreateSecurityGroup var1);

    @Path(value="/security-groups/{id}")
    @Named(value="security-group:delete")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteSecurityGroup(@PathParam(value="id") String var1);

    @Path(value="/security-group-rules")
    @Named(value="security-group-rule:list")
    @GET
    @ResponseParser(value=ParseRules.class)
    @Transform(value=RulesToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Rule> listRules();

    @Path(value="/security-group-rules")
    @Named(value="security-group-rule:list")
    @GET
    @ResponseParser(value=ParseRules.class)
    @Fallback(value=EmptyRulesFallback.class)
    public Rules listRules(PaginationOptions var1);

    @Path(value="/security-group-rules/{id}")
    @Named(value="security-group-rule:get")
    @GET
    @SelectJson(value={"security_group_rule"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Rule get(@PathParam(value="id") String var1);

    @Path(value="/security-group-rules")
    @Named(value="security-group-rule:create")
    @POST
    @SelectJson(value={"security_group_rule"})
    public Rule create(@WrapWith(value="security_group_rule") Rule.CreateRule var1);

    @Path(value="/security-group-rules/{id}")
    @Named(value="security-group-rule:delete")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteRule(@PathParam(value="id") String var1);
}

