/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.base.Function;
import com.google.common.base.Functions;

import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.PollConfig;

public class ChefAttributePollConfig<T> extends PollConfig<Object, T, ChefAttributePollConfig<T>>{

    private String chefAttributePath;

    public static <T> ChefAttributePollConfig<T> forSensor(AttributeSensor<T> sensor) {
        return new ChefAttributePollConfig<T>(sensor);
    }

    public static ChefAttributePollConfig<Void> forMultiple() {
        return new ChefAttributePollConfig<Void>(PollConfig.NO_SENSOR);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public ChefAttributePollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        onSuccess((Function)Functions.identity());
    }

    public ChefAttributePollConfig(ChefAttributePollConfig<T> other) {
        super(other);
        this.chefAttributePath = other.chefAttributePath;
    }

    public String getChefAttributePath() {
        return chefAttributePath;
    }
    
    public ChefAttributePollConfig<T> chefAttributePath(String val) {
        this.chefAttributePath = val; return this;
    }
    
    @Override protected String toStringBaseName() { return "chef"; }
    @Override protected String toStringPollSource() { return chefAttributePath; }
    
}
