/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;

public final class WhereClause {
    private static final WhereClause EMPTY = new WhereClause(new Builder());
    public final List<Relation> relations;
    public final List<CustomIndexExpression> expressions;

    private WhereClause(Builder builder) {
        this((List<Relation>)builder.relations.build(), (List<CustomIndexExpression>)builder.expressions.build());
    }

    private WhereClause(List<Relation> relations, List<CustomIndexExpression> expressions) {
        this.relations = relations;
        this.expressions = expressions;
    }

    public static WhereClause empty() {
        return EMPTY;
    }

    public WhereClause copy(List<Relation> newRelations) {
        return new WhereClause(newRelations, this.expressions);
    }

    public boolean containsCustomExpressions() {
        return !this.expressions.isEmpty();
    }

    public boolean containsTokenRelations() {
        for (Relation rel : this.relations) {
            if (!rel.onToken()) continue;
            return true;
        }
        return false;
    }

    public static final class Builder {
        ImmutableList.Builder<Relation> relations = new ImmutableList.Builder();
        ImmutableList.Builder<CustomIndexExpression> expressions = new ImmutableList.Builder();

        public Builder add(Relation relation) {
            this.relations.add((Object)relation);
            return this;
        }

        public Builder add(CustomIndexExpression expression) {
            this.expressions.add((Object)expression);
            return this;
        }

        public WhereClause build() {
            return new WhereClause(this);
        }
    }
}

