/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.aggregation;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.aggregation.GroupingState;

public abstract class GroupMaker {
    public static final GroupMaker GROUP_EVERYTHING = new GroupMaker(){

        @Override
        public boolean isNewGroup(DecoratedKey partitionKey, Clustering clustering) {
            return false;
        }

        @Override
        public boolean returnAtLeastOneRow() {
            return true;
        }
    };

    public static GroupMaker newInstance(ClusteringComparator comparator, int clusteringPrefixSize, GroupingState state) {
        return new PkPrefixGroupMaker(comparator, clusteringPrefixSize, state);
    }

    public static GroupMaker newInstance(ClusteringComparator comparator, int clusteringPrefixSize) {
        return new PkPrefixGroupMaker(comparator, clusteringPrefixSize);
    }

    public abstract boolean isNewGroup(DecoratedKey var1, Clustering var2);

    public boolean returnAtLeastOneRow() {
        return false;
    }

    private static final class PkPrefixGroupMaker
    extends GroupMaker {
        private final int clusteringPrefixSize;
        private final ClusteringComparator comparator;
        private ByteBuffer lastPartitionKey;
        private Clustering lastClustering;

        public PkPrefixGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize, GroupingState state) {
            this(comparator, clusteringPrefixSize);
            this.lastPartitionKey = state.partitionKey();
            this.lastClustering = state.clustering;
        }

        public PkPrefixGroupMaker(ClusteringComparator comparator, int clusteringPrefixSize) {
            this.comparator = comparator;
            this.clusteringPrefixSize = clusteringPrefixSize;
        }

        @Override
        public boolean isNewGroup(DecoratedKey partitionKey, Clustering clustering) {
            boolean isNew = false;
            if (!partitionKey.getKey().equals(this.lastPartitionKey)) {
                this.lastPartitionKey = partitionKey.getKey();
                isNew = true;
                if (Clustering.STATIC_CLUSTERING == clustering) {
                    this.lastClustering = null;
                    return true;
                }
            } else if (this.lastClustering != null && this.comparator.compare(this.lastClustering, clustering, this.clusteringPrefixSize) != 0) {
                isNew = true;
            }
            this.lastClustering = clustering;
            return isNew;
        }
    }
}

