/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.stats;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ConcurrentStatsCounter
implements StatsCounter {
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();
    private final LongAdder loadSuccessCount = new LongAdder();
    private final LongAdder loadFailureCount = new LongAdder();
    private final LongAdder totalLoadTime = new LongAdder();
    private final LongAdder evictionCount = new LongAdder();

    @Override
    public void recordHits(@Nonnegative int count) {
        this.hitCount.add(count);
    }

    @Override
    public void recordMisses(@Nonnegative int count) {
        this.missCount.add(count);
    }

    @Override
    public void recordLoadSuccess(@Nonnegative long loadTime) {
        this.loadSuccessCount.increment();
        this.totalLoadTime.add(loadTime);
    }

    @Override
    public void recordLoadFailure(@Nonnegative long loadTime) {
        this.loadFailureCount.increment();
        this.totalLoadTime.add(loadTime);
    }

    @Override
    public void recordEviction() {
        this.evictionCount.increment();
    }

    @Override
    public CacheStats snapshot() {
        return new CacheStats(this.hitCount.sum(), this.missCount.sum(), this.loadSuccessCount.sum(), this.loadFailureCount.sum(), this.totalLoadTime.sum(), this.evictionCount.sum());
    }

    public void incrementBy(@Nonnull StatsCounter other) {
        CacheStats otherStats = other.snapshot();
        this.hitCount.add(otherStats.hitCount());
        this.missCount.add(otherStats.missCount());
        this.loadSuccessCount.add(otherStats.loadSuccessCount());
        this.loadFailureCount.add(otherStats.loadFailureCount());
        this.totalLoadTime.add(otherStats.totalLoadTime());
        this.evictionCount.add(otherStats.evictionCount());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

