/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.stack;

import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.array.LastInArray;
import org.psjava.ds.stack.Stack;
import org.psjava.ds.stack.StackFactory;

public class StackFactoryUsingDynamicArray {
    public static StackFactory getInstance() {
        return new StackFactory(){

            @Override
            public <T> Stack<T> create() {
                return new Stack<T>(){
                    DynamicArray<T> a = DynamicArray.create();

                    @Override
                    public boolean isEmpty() {
                        return this.a.isEmpty();
                    }

                    @Override
                    public T pop() {
                        return this.a.removeLast();
                    }

                    @Override
                    public void push(T v) {
                        this.a.addToLast(v);
                    }

                    @Override
                    public T top() {
                        return LastInArray.getLast(this.a);
                    }

                    public String toString() {
                        return this.a.toString();
                    }
                };
            }
        };
    }

    private StackFactoryUsingDynamicArray() {
    }
}

