/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.net.AsyncChannelOutputPlus;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.SharedDefaultFileRegion;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.utils.memory.BufferPool;
import org.apache.cassandra.utils.memory.BufferPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStreamingOutputPlus
extends AsyncChannelOutputPlus {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStreamingOutputPlus.class);
    private final BufferPool bufferPool = BufferPools.forNetworking();
    final int defaultLowWaterMark;
    final int defaultHighWaterMark;

    public AsyncStreamingOutputPlus(Channel channel) {
        super(channel);
        WriteBufferWaterMark waterMark = channel.config().getWriteBufferWaterMark();
        this.defaultLowWaterMark = waterMark.low();
        this.defaultHighWaterMark = waterMark.high();
        this.allocateBuffer();
    }

    private void allocateBuffer() {
        this.buffer = this.bufferPool.getAtLeast(8192, BufferType.OFF_HEAP);
    }

    @Override
    protected void doFlush(int count) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        ByteBuffer flush = this.buffer;
        if (flush.position() == 0) {
            return;
        }
        flush.flip();
        int byteCount = flush.limit();
        ChannelPromise promise = this.beginFlush(byteCount, 0, Integer.MAX_VALUE);
        this.channel.writeAndFlush((Object)GlobalBufferPoolAllocator.wrap(flush), promise);
        this.allocateBuffer();
    }

    @Override
    public long position() {
        return this.flushed() + (long)this.buffer.position();
    }

    public int writeToChannel(Write write, StreamManager.StreamRateLimiter limiter) throws IOException {
        this.doFlush(0);
        class Holder {
            ChannelPromise promise;
            ByteBuffer buffer;

            Holder() {
            }
        }
        Holder holder = new Holder();
        try {
            write.write((int size) -> {
                if (holder.buffer != null) {
                    throw new IllegalStateException("Can only allocate one ByteBuffer");
                }
                limiter.acquire(size);
                holder.promise = this.beginFlush(size, this.defaultLowWaterMark, this.defaultHighWaterMark);
                holder.buffer = this.bufferPool.get(size, BufferType.OFF_HEAP);
                return holder.buffer;
            });
        }
        catch (Throwable t) {
            if (holder.buffer != null) {
                this.bufferPool.put(holder.buffer);
            }
            if (holder.promise != null) {
                holder.promise.tryFailure(t);
            }
            throw t;
        }
        ByteBuffer buffer = holder.buffer;
        this.bufferPool.putUnusedPortion(buffer);
        int length = buffer.limit();
        this.channel.writeAndFlush((Object)GlobalBufferPoolAllocator.wrap(buffer), holder.promise);
        return length;
    }

    public long writeFileToChannel(FileChannel file, StreamManager.StreamRateLimiter limiter) throws IOException {
        if (this.channel.pipeline().get(SslHandler.class) != null) {
            return this.writeFileToChannel(file, limiter, 65536);
        }
        return this.writeFileToChannelZeroCopy(file, limiter, 0x100000, 0x100000, 0x200000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long writeFileToChannel(FileChannel fc, StreamManager.StreamRateLimiter limiter, int batchSize) throws IOException {
        long bytesTransferred;
        long length = fc.size();
        try {
            int toWrite;
            for (bytesTransferred = 0L; bytesTransferred < length; bytesTransferred += (long)toWrite) {
                toWrite = (int)Math.min((long)batchSize, length - bytesTransferred);
                long position = bytesTransferred;
                this.writeToChannel(bufferSupplier -> {
                    ByteBuffer outBuffer = bufferSupplier.get(toWrite);
                    long read = fc.read(outBuffer, position);
                    if (read != (long)toWrite) {
                        throw new IOException(String.format("could not read required number of bytes from file to be streamed: read %d bytes, wanted %d bytes", read, toWrite));
                    }
                    outBuffer.flip();
                }, limiter);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Writing {} bytes at position {} of {}", new Object[]{toWrite, bytesTransferred, length});
            }
        }
        finally {
            fc.close();
        }
        return bytesTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long writeFileToChannelZeroCopy(FileChannel file, StreamManager.StreamRateLimiter limiter, int batchSize, int lowWaterMark, int highWaterMark) throws IOException {
        long length = file.size();
        SharedDefaultFileRegion.SharedFileChannel sharedFile = SharedDefaultFileRegion.share(file);
        try {
            long bytesTransferred;
            int toWrite;
            for (bytesTransferred = 0L; bytesTransferred < length; bytesTransferred += (long)toWrite) {
                toWrite = (int)Math.min((long)batchSize, length - bytesTransferred);
                limiter.acquire(toWrite);
                ChannelPromise promise = this.beginFlush(toWrite, lowWaterMark, highWaterMark);
                SharedDefaultFileRegion fileRegion = new SharedDefaultFileRegion(sharedFile, bytesTransferred, toWrite);
                this.channel.writeAndFlush((Object)fileRegion, promise);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Writing {} bytes at position {} of {}", new Object[]{toWrite, bytesTransferred, length});
            }
            long l = bytesTransferred;
            return l;
        }
        finally {
            sharedFile.release();
        }
    }

    @Override
    public void discard() {
        if (this.buffer != null) {
            this.bufferPool.put(this.buffer);
            this.buffer = null;
        }
    }

    public static interface Write {
        public void write(BufferSupplier var1) throws IOException;
    }

    public static interface BufferSupplier {
        public ByteBuffer get(int var1) throws IOException;
    }
}

