/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.DebuggableTask;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.FutureTask;
import org.apache.cassandra.concurrent.LocalAwareExecutorPlus;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.SEPExecutorMBean;
import org.apache.cassandra.concurrent.SEPWorker;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.concurrent.TaskFactory;
import org.apache.cassandra.metrics.ThreadPoolMetrics;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.WithResources;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEPExecutor
implements LocalAwareExecutorPlus,
SEPExecutorMBean {
    private static final Logger logger = LoggerFactory.getLogger(SEPExecutor.class);
    private static final TaskFactory taskFactory = TaskFactory.localAware();
    private final SharedExecutorPool pool;
    private final AtomicInteger maximumPoolSize;
    private final ExecutorPlus.MaximumPoolSizeListener maximumPoolSizeListener;
    public final String name;
    private final String mbeanName;
    @VisibleForTesting
    public final ThreadPoolMetrics metrics;
    private final AtomicLong permits = new AtomicLong();
    private final AtomicLong completedTasks = new AtomicLong();
    volatile boolean shuttingDown = false;
    final Condition shutdown = Condition.newOneTimeCondition();
    protected final ConcurrentLinkedQueue<Runnable> tasks = new ConcurrentLinkedQueue();

    SEPExecutor(SharedExecutorPool pool, int maximumPoolSize, ExecutorPlus.MaximumPoolSizeListener maximumPoolSizeListener, String jmxPath, String name) {
        this.pool = pool;
        this.name = NamedThreadFactory.globalPrefix() + name;
        this.mbeanName = "org.apache.cassandra." + jmxPath + ":type=" + name;
        this.maximumPoolSize = new AtomicInteger(maximumPoolSize);
        this.maximumPoolSizeListener = maximumPoolSizeListener;
        this.permits.set(SEPExecutor.combine(0, maximumPoolSize));
        this.metrics = new ThreadPoolMetrics(this, jmxPath, name).register();
        MBeanWrapper.instance.registerMBean((Object)this, this.mbeanName);
    }

    protected void onCompletion() {
        this.completedTasks.incrementAndGet();
    }

    @Override
    public long oldestTaskQueueTime() {
        Runnable task = this.tasks.peek();
        if (!(task instanceof FutureTask)) {
            return 0L;
        }
        FutureTask futureTask = (FutureTask)task;
        DebuggableTask debuggableTask = futureTask.debuggableTask();
        if (debuggableTask == null) {
            return 0L;
        }
        return debuggableTask.elapsedSinceCreation();
    }

    @Override
    public int getMaxTasksQueued() {
        return Integer.MAX_VALUE;
    }

    boolean maybeSchedule() {
        if (this.pool.spinningCount.get() > 0 || !this.takeWorkPermit(true)) {
            return false;
        }
        this.pool.schedule(new SEPWorker.Work(this));
        return true;
    }

    protected <T extends Runnable> T addTask(T task) {
        int taskPermits;
        long current;
        this.tasks.add(task);
        while (!this.permits.compareAndSet(current = this.permits.get(), SEPExecutor.updateTaskPermits(current, (taskPermits = SEPExecutor.taskPermits(current)) + 1))) {
        }
        if (taskPermits == 0) {
            this.pool.maybeStartSpinningWorker();
        }
        return task;
    }

    TakeTaskPermitResult takeTaskPermit(boolean checkForWorkPermitOvercommit) {
        TakeTaskPermitResult result;
        long updated;
        long current;
        do {
            current = this.permits.get();
            int workPermits = SEPExecutor.workPermits(current);
            int taskPermits = SEPExecutor.taskPermits(current);
            if (workPermits < 0 && checkForWorkPermitOvercommit) {
                result = TakeTaskPermitResult.RETURNED_WORK_PERMIT;
                updated = SEPExecutor.updateWorkPermits(current, workPermits + 1);
                continue;
            }
            if (taskPermits == 0) {
                return TakeTaskPermitResult.NONE_AVAILABLE;
            }
            result = TakeTaskPermitResult.TOOK_PERMIT;
            updated = SEPExecutor.updateTaskPermits(current, taskPermits - 1);
        } while (!this.permits.compareAndSet(current, updated));
        return result;
    }

    boolean takeWorkPermit(boolean takeTaskPermit) {
        int workPermits;
        int taskPermits;
        long current;
        int taskDelta = takeTaskPermit ? 1 : 0;
        do {
            current = this.permits.get();
            workPermits = SEPExecutor.workPermits(current);
            taskPermits = SEPExecutor.taskPermits(current);
            if (workPermits > 0 && taskPermits != 0) continue;
            return false;
        } while (!this.permits.compareAndSet(current, SEPExecutor.combine(taskPermits - taskDelta, workPermits - 1)));
        return true;
    }

    void returnWorkPermit() {
        int workPermits;
        long current;
        while (!this.permits.compareAndSet(current = this.permits.get(), SEPExecutor.updateWorkPermits(current, (workPermits = SEPExecutor.workPermits(current)) + 1))) {
        }
    }

    @Override
    public void maybeExecuteImmediately(Runnable task) {
        task = taskFactory.toExecute(task);
        if (!this.takeWorkPermit(false)) {
            this.addTask(task);
        } else {
            try {
                task.run();
            }
            finally {
                this.returnWorkPermit();
                this.maybeSchedule();
            }
        }
    }

    @Override
    public void execute(Runnable run) {
        this.addTask(taskFactory.toExecute(run));
    }

    @Override
    public void execute(WithResources withResources, Runnable run) {
        this.addTask(taskFactory.toExecute(withResources, run));
    }

    @Override
    public Future<?> submit(Runnable run) {
        return this.addTask(taskFactory.toSubmit(run));
    }

    @Override
    public <T> Future<T> submit(Runnable run, T result) {
        return this.addTask(taskFactory.toSubmit(run, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> call) {
        return this.addTask(taskFactory.toSubmit(call));
    }

    @Override
    public <T> Future<T> submit(WithResources withResources, Runnable run, T result) {
        return this.addTask(taskFactory.toSubmit(withResources, run, result));
    }

    @Override
    public Future<?> submit(WithResources withResources, Runnable run) {
        return this.addTask(taskFactory.toSubmit(withResources, run));
    }

    @Override
    public <T> Future<T> submit(WithResources withResources, Callable<T> call) {
        return this.addTask(taskFactory.toSubmit(withResources, call));
    }

    @Override
    public boolean inExecutor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void shutdown() {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        this.pool.executors.remove(this);
        if (this.getActiveTaskCount() == 0) {
            this.shutdown.signalAll();
        }
        this.metrics.release();
        MBeanWrapper.instance.unregisterMBean(this.mbeanName);
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.shutdown();
        ArrayList<Runnable> aborted = new ArrayList<Runnable>();
        while (this.takeTaskPermit(false) == TakeTaskPermitResult.TOOK_PERMIT) {
            aborted.add(this.tasks.poll());
        }
        return aborted;
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown;
    }

    @Override
    public boolean isTerminated() {
        return this.shuttingDown && this.shutdown.isSignalled();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.shutdown.await(timeout, unit);
        return this.isTerminated();
    }

    @Override
    public int getPendingTaskCount() {
        return SEPExecutor.taskPermits(this.permits.get());
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completedTasks.get();
    }

    @Override
    public int getActiveTaskCount() {
        return this.maximumPoolSize.get() - SEPExecutor.workPermits(this.permits.get());
    }

    @Override
    public int getCorePoolSize() {
        return 0;
    }

    @Override
    public void setCorePoolSize(int newCorePoolSize) {
        throw new IllegalArgumentException("Cannot resize core pool size of SEPExecutor");
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize.get();
    }

    @Override
    public synchronized void setMaximumPoolSize(int newMaximumPoolSize) {
        int oldMaximumPoolSize = this.maximumPoolSize.get();
        if (newMaximumPoolSize < 0) {
            throw new IllegalArgumentException("Maximum number of workers must not be negative");
        }
        int deltaWorkPermits = newMaximumPoolSize - oldMaximumPoolSize;
        if (!this.maximumPoolSize.compareAndSet(oldMaximumPoolSize, newMaximumPoolSize)) {
            throw new IllegalStateException("Maximum pool size has been changed while resizing");
        }
        if (deltaWorkPermits == 0) {
            return;
        }
        this.permits.updateAndGet(cur -> SEPExecutor.updateWorkPermits(cur, SEPExecutor.workPermits(cur) + deltaWorkPermits));
        logger.info("Resized {} maximum pool size from {} to {}", new Object[]{this.name, oldMaximumPoolSize, newMaximumPoolSize});
        this.pool.maybeStartSpinningWorker();
        this.maximumPoolSizeListener.onUpdateMaximumPoolSize(newMaximumPoolSize);
    }

    private static int taskPermits(long both) {
        return (int)both;
    }

    private static int workPermits(long both) {
        return (int)(both >> 32);
    }

    private static long updateTaskPermits(long prev, int taskPermits) {
        return prev & 0xFFFFFFFF00000000L | (long)taskPermits;
    }

    private static long updateWorkPermits(long prev, int workPermits) {
        return (long)workPermits << 32 | prev & 0xFFFFFFFFL;
    }

    private static long combine(int taskPermits, int workPermits) {
        return (long)workPermits << 32 | (long)taskPermits;
    }

    public static enum TakeTaskPermitResult {
        NONE_AVAILABLE,
        TOOK_PERMIT,
        RETURNED_WORK_PERMIT;

    }
}

