/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.StorageAttachedIndexGroup;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAttachedIndexBuilder
extends SecondaryIndexBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(StorageAttachedIndexBuilder.class);
    private static final Map<SSTableReader, CountDownLatch> inProgress = Maps.newConcurrentMap();
    private final StorageAttachedIndexGroup group;
    private final TableMetadata metadata;
    private final Tracker tracker;
    private final TimeUUID compactionId = TimeUUID.Generator.nextTimeUUID();
    private final boolean isFullRebuild;
    private final boolean isInitialBuild;
    private final SortedMap<SSTableReader, Set<StorageAttachedIndex>> sstables;
    private long bytesProcessed = 0L;
    private final long totalSizeInBytes;

    StorageAttachedIndexBuilder(StorageAttachedIndexGroup group, SortedMap<SSTableReader, Set<StorageAttachedIndex>> sstables, boolean isFullRebuild, boolean isInitialBuild) {
        this.group = group;
        this.metadata = group.metadata();
        this.sstables = sstables;
        this.tracker = group.table().getTracker();
        this.isFullRebuild = isFullRebuild;
        this.isInitialBuild = isInitialBuild;
        this.totalSizeInBytes = sstables.keySet().stream().mapToLong(SSTableReader::uncompressedLength).sum();
    }

    @Override
    public void build() {
        logger.debug(this.logMessage(String.format("Starting %s %s index build...", this.isInitialBuild ? "initial" : "non-initial", this.isFullRebuild ? "full" : "partial")));
        for (Map.Entry<SSTableReader, Set<StorageAttachedIndex>> e : this.sstables.entrySet()) {
            SSTableReader sstable = e.getKey();
            Set<StorageAttachedIndex> indexes = e.getValue();
            Set<StorageAttachedIndex> existing = this.validateIndexes(indexes, sstable.descriptor);
            if (existing.isEmpty()) {
                logger.debug(this.logMessage("{} dropped during index build"), indexes);
                continue;
            }
            if (!this.indexSSTable(sstable, existing)) continue;
            return;
        }
    }

    private String logMessage(String message) {
        return String.format("[%s.%s.*] %s", this.metadata.keyspace, this.metadata.name, message);
    }

    /*
     * Exception decompiling
     */
    private boolean indexSSTable(SSTableReader sstable, Set<StorageAttachedIndex> indexes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.metadata, OperationType.INDEX_BUILD, this.bytesProcessed, this.totalSizeInBytes, this.compactionId, this.sstables.keySet());
    }

    private CountDownLatch shouldWritePerSSTableFiles(SSTableReader sstable) {
        CountDownLatch latch;
        IndexDescriptor indexDescriptor = IndexDescriptor.create(sstable);
        if (!(indexDescriptor.isPerSSTableIndexBuildComplete() && !this.isFullRebuild && indexDescriptor.validatePerSSTableComponents(IndexValidation.CHECKSUM, true, false) || inProgress.putIfAbsent(sstable, latch = CountDownLatch.newCountDownLatch(1)) != null)) {
            this.group.deletePerSSTableFiles(Collections.singleton(sstable));
            return latch;
        }
        return null;
    }

    private void completeSSTable(SSTableFlushObserver indexWriter, SSTableReader sstable, Set<StorageAttachedIndex> indexes, CountDownLatch latch) throws InterruptedException {
        indexWriter.complete();
        if (latch != null) {
            latch.decrement();
        } else {
            latch = inProgress.get(sstable);
            if (latch != null) {
                latch.await();
            }
        }
        Set<StorageAttachedIndex> existing = this.validateIndexes(indexes, sstable.descriptor);
        if (existing.isEmpty()) {
            logger.debug(this.logMessage("{} dropped during index build"), indexes);
            return;
        }
        sstable.registerComponents(StorageAttachedIndexGroup.getLiveComponents(sstable, existing), this.tracker);
        Set<StorageAttachedIndex> incomplete = this.group.onSSTableChanged(Collections.emptyList(), Collections.singleton(sstable), existing, IndexValidation.NONE);
        if (!incomplete.isEmpty()) {
            throw new RuntimeException(this.logMessage("Failed to update views on column indexes " + incomplete + " on indexes " + indexes + "."));
        }
    }

    private Set<StorageAttachedIndex> validateIndexes(Set<StorageAttachedIndex> indexes, Descriptor descriptor) {
        HashSet<StorageAttachedIndex> existing = new HashSet<StorageAttachedIndex>();
        HashSet<StorageAttachedIndex> dropped = new HashSet<StorageAttachedIndex>();
        for (StorageAttachedIndex index : indexes) {
            if (this.group.containsIndex(index)) {
                existing.add(index);
                continue;
            }
            dropped.add(index);
        }
        if (!dropped.isEmpty()) {
            String droppedIndexes = dropped.stream().map(sai -> sai.identifier().indexName).collect(Collectors.toList()).toString();
            if (this.isFullRebuild) {
                throw new RuntimeException(this.logMessage(String.format("%s are dropped, will stop index build.", droppedIndexes)));
            }
            logger.debug(this.logMessage("Skip building dropped index {} on sstable {}"), (Object)droppedIndexes, (Object)descriptor.baseFile());
        }
        return existing;
    }

    private static /* synthetic */ void lambda$indexSSTable$0(IndexDescriptor indexDescriptor, StorageAttachedIndex index) {
        indexDescriptor.deleteColumnIndex(index.termType(), index.identifier());
    }
}

