/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.io;

import java.io.IOException;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.lucene.store.IndexInput;

public class IndexInputReader
extends IndexInput {
    private final RandomAccessReader input;
    private final Runnable doOnClose;

    private IndexInputReader(RandomAccessReader input, Runnable doOnClose) {
        super(input.getPath());
        this.input = input;
        this.doOnClose = doOnClose;
    }

    public static IndexInputReader create(RandomAccessReader input) {
        return new IndexInputReader(input, () -> {});
    }

    public static IndexInputReader create(RandomAccessReader input, Runnable doOnClose) {
        return new IndexInputReader(input, doOnClose);
    }

    public static IndexInputReader create(FileHandle handle) {
        RandomAccessReader reader = handle.createReader();
        return new IndexInputReader(reader, () -> {});
    }

    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    public void readBytes(byte[] bytes, int off, int len) throws IOException {
        this.input.readFully(bytes, off, len);
    }

    public void close() {
        try {
            this.input.close();
        }
        finally {
            this.doOnClose.run();
        }
    }

    public long getFilePointer() {
        return this.input.getFilePointer();
    }

    public void seek(long position) {
        this.input.seek(position);
    }

    public long length() {
        return this.input.length();
    }

    public IndexInput slice(String sliceDescription, long offset, long length) {
        throw new UnsupportedOperationException("Slice operations are not supported");
    }
}

