/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.index.sai.utils.PartitionInfo;
import org.apache.cassandra.schema.TableMetadata;

public class InMemoryPartitionIterator
implements PartitionIterator {
    private final ReadCommand command;
    private final Iterator<Map.Entry<PartitionInfo, TreeSet<Unfiltered>>> partitions;

    public InMemoryPartitionIterator(ReadCommand command, TreeMap<PartitionInfo, TreeSet<Unfiltered>> rowsByPartitions) {
        this.command = command;
        this.partitions = rowsByPartitions.entrySet().iterator();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.partitions.hasNext();
    }

    @Override
    public RowIterator next() {
        return new InMemoryRowIterator(this.partitions.next());
    }

    private class InMemoryRowIterator
    implements RowIterator {
        private final PartitionInfo partitionInfo;
        private final Iterator<Unfiltered> rows;

        public InMemoryRowIterator(Map.Entry<PartitionInfo, TreeSet<Unfiltered>> rows) {
            this.partitionInfo = rows.getKey();
            this.rows = rows.getValue().iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.rows.hasNext();
        }

        @Override
        public Row next() {
            return (Row)this.rows.next();
        }

        @Override
        public TableMetadata metadata() {
            return InMemoryPartitionIterator.this.command.metadata();
        }

        @Override
        public boolean isReverseOrder() {
            return InMemoryPartitionIterator.this.command.isReversed();
        }

        @Override
        public RegularAndStaticColumns columns() {
            return InMemoryPartitionIterator.this.command.metadata().regularAndStaticColumns();
        }

        @Override
        public DecoratedKey partitionKey() {
            return this.partitionInfo.key;
        }

        @Override
        public Row staticRow() {
            return this.partitionInfo.staticRow;
        }
    }
}

