/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.diag.DiagnosticEvent;

final class PendingRangeCalculatorServiceEvent
extends DiagnosticEvent {
    private final PendingRangeCalculatorServiceEventType type;
    private final int taskCount;

    PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEventType type) {
        this(type, -1);
    }

    PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEventType type, int taskCount) {
        this.type = type;
        this.taskCount = taskCount;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public PendingRangeCalculatorServiceEventType getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        if (this.taskCount < 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("taskCount", Integer.valueOf(this.taskCount));
        return ret;
    }

    public static enum PendingRangeCalculatorServiceEventType {
        TASK_STARTED,
        TASK_FINISHED_SUCCESSFULLY,
        TASK_EXECUTION_REJECTED,
        TASK_COUNT_CHANGED;

    }
}

