/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.Replica;

public class StreamRequest {
    public static final IVersionedSerializer<StreamRequest> serializer = new StreamRequestSerializer();
    public final String keyspace;
    public final RangesAtEndpoint full;
    public final RangesAtEndpoint transientReplicas;
    public final Collection<String> columnFamilies = new HashSet<String>();

    public StreamRequest(String keyspace, RangesAtEndpoint full, RangesAtEndpoint transientReplicas, Collection<String> columnFamilies) {
        this.keyspace = keyspace;
        if (!full.endpoint().equals(transientReplicas.endpoint())) {
            throw new IllegalStateException("Mismatching endpoints: " + full + ", " + transientReplicas);
        }
        this.full = full;
        this.transientReplicas = transientReplicas;
        this.columnFamilies.addAll(columnFamilies);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keyspace", (Object)this.keyspace).add("tables", this.columnFamilies).add("full", (Object)this.full).add("transientReplicas", (Object)this.transientReplicas).omitNullValues().toString();
    }

    public static class StreamRequestSerializer
    implements IVersionedSerializer<StreamRequest> {
        @Override
        public void serialize(StreamRequest request, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(request.keyspace);
            out.writeInt(request.columnFamilies.size());
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(request.full.endpoint(), out, version);
            this.serializeReplicas(request.full, out, version);
            this.serializeReplicas(request.transientReplicas, out, version);
            for (String cf : request.columnFamilies) {
                out.writeUTF(cf);
            }
        }

        private void serializeReplicas(RangesAtEndpoint replicas, DataOutputPlus out, int version) throws IOException {
            out.writeInt(replicas.size());
            for (Replica replica : replicas) {
                IPartitioner.validate(replica.range());
                Token.serializer.serialize((Token)replica.range().left, out, version);
                Token.serializer.serialize((Token)replica.range().right, out, version);
            }
        }

        @Override
        public StreamRequest deserialize(DataInputPlus in, int version) throws IOException {
            String keyspace = in.readUTF();
            int cfCount = in.readInt();
            InetAddressAndPort endpoint = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            RangesAtEndpoint full = this.deserializeReplicas(in, version, endpoint, true);
            RangesAtEndpoint transientReplicas = this.deserializeReplicas(in, version, endpoint, false);
            ArrayList<String> columnFamilies = new ArrayList<String>(cfCount);
            for (int i = 0; i < cfCount; ++i) {
                columnFamilies.add(in.readUTF());
            }
            return new StreamRequest(keyspace, full, transientReplicas, columnFamilies);
        }

        RangesAtEndpoint deserializeReplicas(DataInputPlus in, int version, InetAddressAndPort endpoint, boolean isFull) throws IOException {
            int replicaCount = in.readInt();
            RangesAtEndpoint.Builder replicas = RangesAtEndpoint.builder(endpoint, replicaCount);
            for (int i = 0; i < replicaCount; ++i) {
                Token left = Token.serializer.deserialize(in, IPartitioner.global(), version);
                Token right = Token.serializer.deserialize(in, IPartitioner.global(), version);
                replicas.add(new Replica(endpoint, new Range<Token>(left, right), isFull));
            }
            return replicas.build();
        }

        @Override
        public long serializedSize(StreamRequest request, int version) {
            int size = TypeSizes.sizeof(request.keyspace);
            size += TypeSizes.sizeof(request.columnFamilies.size());
            size = (int)((long)size + InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(request.full.endpoint(), version));
            size = (int)((long)size + this.replicasSerializedSize(request.transientReplicas, version));
            size = (int)((long)size + this.replicasSerializedSize(request.full, version));
            for (String cf : request.columnFamilies) {
                size += TypeSizes.sizeof(cf);
            }
            return size;
        }

        private long replicasSerializedSize(RangesAtEndpoint replicas, int version) {
            long size = 0L;
            size += (long)TypeSizes.sizeof(replicas.size());
            for (Replica replica : replicas) {
                size += Token.serializer.serializedSize((Token)replica.range().left, version);
                size += Token.serializer.serializedSize((Token)replica.range().right, version);
            }
            return size;
        }
    }
}

