/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.core.metamodel.specloader.specimpl;

import java.util.function.Function;

import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;

import lombok.experimental.UtilityClass;

/** package private utility */
@UtilityClass
class _MixedInMemberFactory {

    // -- MIXINS

    Function<ObjectActionDefault, ObjectActionMixedIn> mixedInAction(
            final ObjectSpecification mixeeSpec,
            final Class<?> mixinType,
            final String mixinMethodName) {

        return mixinAction -> new ObjectActionMixedIn(
                mixinType, mixinMethodName, mixinAction, mixeeSpec);
    }

    Function<ObjectActionDefault, ObjectAssociation> mixedInAssociation(
            final ObjectSpecification mixeeSpec,
            final Class<?> mixinType,
            final String mixinMethodName) {

        return mixinAction ->
            mixinAction.getReturnType().isSingular()
                ? new OneToOneAssociationMixedIn(
                        mixeeSpec, mixinAction, mixinType, mixinMethodName)
                : new OneToManyAssociationMixedIn(
                        mixeeSpec, mixinAction, mixinType, mixinMethodName);
    }

}
