/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v6;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.upgrade.BaseUpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.v6.XMLDataChannelDescriptorLoader_V3_0_0_1;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;

class UpgradeHandler_V6
extends BaseUpgradeHandler {
    static final String TO_VERSION = "6";
    private XMLDataChannelDescriptorLoader_V3_0_0_1 projectLoader = new XMLDataChannelDescriptorLoader_V3_0_0_1();
    @Inject
    private ProjectSaver projectSaver;

    UpgradeHandler_V6(Resource source) {
        super(source);
    }

    @Override
    protected Resource doPerformUpgrade(UpgradeMetaData metaData) throws ConfigurationException {
        List<DataChannelDescriptor> domains = this.projectLoader.load(this.projectSource);
        if (domains.isEmpty()) {
            DataChannelDescriptor descriptor = new DataChannelDescriptor();
            descriptor.setName("DEFAULT");
            domains.add(descriptor);
        }
        ArrayList<Resource> resourcesToDelete = new ArrayList<Resource>();
        for (DataChannelDescriptor descriptor : domains) {
            for (DataNodeDescriptor node : descriptor.getNodeDescriptors()) {
                Resource nodeResource = node.getConfigurationSource();
                if (nodeResource == null) continue;
                resourcesToDelete.add(nodeResource);
            }
        }
        for (DataChannelDescriptor descriptor : domains) {
            Project project = new Project(new ConfigurationTree((ConfigurationNode)descriptor));
            this.attachToNamespace((DataChannelDescriptor)project.getRootNode());
            this.projectSaver.save(project);
        }
        for (Resource resource : resourcesToDelete) {
            try {
                File file = Util.toFile((URL)resource.getURL());
                if (!file.exists() || !file.getName().endsWith(".driver.xml")) continue;
                file.delete();
            }
            catch (Exception exception) {}
        }
        return domains.get(0).getConfigurationSource();
    }

    @Override
    protected String getToVersion() {
        return TO_VERSION;
    }
}

