/*
 * Decompiled with CFR 0.152.
 */
package foundrylogic.vpp;

import foundrylogic.vpp.VPPConfig;
import foundrylogic.vpp.VPPCopyImpl;
import foundrylogic.vpp.VPPCopyTool;
import foundrylogic.vpp.VPPFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;
import org.apache.velocity.VelocityContext;

public class VPPCopy
extends Copy {
    protected static VPPCopyImpl _vppCopyImpl;
    protected VPPFilter _vppFilter = new VPPFilter();
    static /* synthetic */ Class class$foundrylogic$vpp$VPPCopy;

    public VPPCopy() {
        FilterChain filterChain = this.createFilterChain();
        filterChain.getFilterReaders().add(this._vppFilter);
    }

    public void addConfiguredConfig(VPPConfig vPPConfig) {
        this._vppFilter.addConfiguredConfig(vPPConfig);
    }

    public void execute() throws BuildException {
        this._vppFilter.setProject(this.getProject());
        this._vppFilter.initialize();
        super.execute();
    }

    protected void doFileOperations() {
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            VPPConfig vPPConfig = this._vppFilter.getConfig();
            VelocityContext velocityContext = vPPConfig.getVelocityContext();
            Enumeration enumeration = this.fileCopyMap.keys();
            Vector vector = this.getFilterChains();
            String string = this.getEncoding();
            String string2 = _vppCopyImpl.getOutputEncoding(this);
            FileUtils fileUtils = this.getFileUtils();
            Project project = this.getProject();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String[] stringArray = _vppCopyImpl.getToFiles(string3, this.fileCopyMap);
                for (int i = 0; i < stringArray.length; ++i) {
                    File file;
                    Object object;
                    String string4 = stringArray[i];
                    if (string3.equals(string4)) {
                        this.log("Skipping self-copy of " + string3, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + string3 + " to " + string4, this.verbosity);
                        FilterSetCollection filterSetCollection = new FilterSetCollection();
                        if (this.filtering) {
                            filterSetCollection.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        object = this.getFilterSets().elements();
                        while (object.hasMoreElements()) {
                            filterSetCollection.addFilterSet((FilterSet)object.nextElement());
                        }
                        object = new File(string3);
                        file = new File(string4);
                        velocityContext.put("vpp", new VPPCopyTool((File)object, file, string, string2));
                        _vppCopyImpl.copyFile(fileUtils, (File)object, file, filterSetCollection, vector, this.forceOverwrite, this.preserveLastModified, string, string2, project);
                        continue;
                    }
                    catch (Exception exception) {
                        object = "Failed to copy " + string3 + " to " + string4 + " due to " + exception.getMessage();
                        file = new File(string4);
                        if (file.exists() && !file.delete()) {
                            object = (String)object + " and I couldn't delete the corrupt " + string4;
                        }
                        throw new BuildException((String)object, (Throwable)exception, this.getLocation());
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Properties properties = new Properties();
        InputStream inputStream = (class$foundrylogic$vpp$VPPCopy == null ? (class$foundrylogic$vpp$VPPCopy = VPPCopy.class$("foundrylogic.vpp.VPPCopy")) : class$foundrylogic$vpp$VPPCopy).getResourceAsStream("/org/apache/tools/ant/version.txt");
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new BuildException("could not load ant version information", (Throwable)iOException);
        }
        String string = properties.getProperty("VERSION");
        if (string.compareTo("1.6") > -1) {
            try {
                _vppCopyImpl = (VPPCopyImpl)Class.forName("foundrylogic.vpp.VPPCopyImpl16").newInstance();
            }
            catch (Exception exception) {
                throw new BuildException("could not load class 'foundrylogic.vpp.VPPCopyImpl16'");
            }
        } else if (string.compareTo("1.5") > -1) {
            try {
                _vppCopyImpl = (VPPCopyImpl)Class.forName("foundrylogic.vpp.VPPCopyImpl15").newInstance();
            }
            catch (Exception exception) {
                throw new BuildException("could not load class 'foundrylogic.vpp.VPPCopyImpl15'");
            }
        } else {
            throw new BuildException("vpp does not support ant version '" + string + "'");
        }
    }
}

