/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.dbload.AbstractLoader;
import org.apache.cayenne.dbsync.reverse.dbload.AttributeLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.EntityLoader;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKeyLoader;
import org.apache.cayenne.dbsync.reverse.dbload.PrimaryKeyLoader;
import org.apache.cayenne.dbsync.reverse.dbload.ProcedureColumnLoader;
import org.apache.cayenne.dbsync.reverse.dbload.ProcedureLoader;
import org.apache.cayenne.dbsync.reverse.dbload.RelationshipLoader;
import org.apache.cayenne.map.DataMap;

public class DbLoader {
    private List<AbstractLoader> loaders = new ArrayList<AbstractLoader>();
    private final Connection connection;
    private final DbAdapter adapter;
    private final DbLoaderConfiguration config;
    private final DbLoaderDelegate delegate;
    private final ObjectNameGenerator nameGenerator;

    public DbLoader(DbAdapter adapter, Connection connection, DbLoaderConfiguration config, DbLoaderDelegate delegate, ObjectNameGenerator nameGenerator) {
        this.adapter = Objects.requireNonNull(adapter);
        this.connection = Objects.requireNonNull(connection);
        this.config = Objects.requireNonNull(config);
        this.nameGenerator = Objects.requireNonNull(nameGenerator);
        this.delegate = delegate == null ? new DefaultDbLoaderDelegate() : delegate;
        this.createLoaders();
    }

    private void createLoaders() {
        this.loaders.add(new EntityLoader(this.adapter, this.config, this.delegate));
        this.loaders.add(new AttributeLoader(this.adapter, this.config, this.delegate));
        this.loaders.add(new PrimaryKeyLoader(this.config, this.delegate));
        this.loaders.add(new ExportedKeyLoader(this.config, this.delegate));
        this.loaders.add(new RelationshipLoader(this.config, this.delegate, this.nameGenerator));
        this.loaders.add(new ProcedureLoader(this.adapter, this.config, this.delegate));
        this.loaders.add(new ProcedureColumnLoader(this.adapter, this.config, this.delegate));
    }

    public DataMap load() throws SQLException {
        DbLoadDataStore loadedData = new DbLoadDataStore();
        DatabaseMetaData metaData = this.connection.getMetaData();
        for (AbstractLoader loader : this.loaders) {
            loader.load(metaData, loadedData);
        }
        return loadedData;
    }

    public static List<String> loadCatalogs(Connection connection) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getCatalogs();){
            List<String> list = DbLoader.getStrings(rs);
            return list;
        }
    }

    public static List<String> loadSchemas(Connection connection) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getSchemas();){
            List<String> list = DbLoader.getStrings(rs);
            return list;
        }
    }

    private static List<String> getStrings(ResultSet rs) throws SQLException {
        ArrayList<String> strings = new ArrayList<String>();
        while (rs.next()) {
            strings.add(rs.getString(1));
        }
        return strings;
    }
}

