/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.cayenne.dbsync.merge.AbstractMerger;
import org.apache.cayenne.dbsync.merge.ChainMerger;
import org.apache.cayenne.dbsync.merge.DbAttributeMerger;
import org.apache.cayenne.dbsync.merge.DbEntityMerger;
import org.apache.cayenne.dbsync.merge.DbRelationshipMerger;
import org.apache.cayenne.dbsync.merge.Merger;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.EmptyValueForNullProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.ValueForNullProvider;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;

public class DataMapMerger
implements Merger<DataMap> {
    private MergerTokenFactory tokenFactory;
    private ValueForNullProvider valueForNull;
    private boolean skipRelationshipsTokens;
    private boolean skipPKTokens;
    private FiltersConfig filters;
    private DbEntityMerger dbEntityMerger;
    private List<AbstractMerger<?, ?>> mergerList = new ArrayList();

    private DataMapMerger() {
    }

    @Override
    public List<MergerToken> createMergeTokens(DataMap original, DataMap importedFromDb) {
        this.prepare(original, importedFromDb);
        this.createDbEntityMerger(original, importedFromDb);
        this.createRelationshipMerger();
        this.createAttributeMerger();
        return this.createTokens();
    }

    private void prepare(DataMap original, DataMap imported) {
        imported.setQuotingSQLIdentifiers(original.isQuotingSQLIdentifiers());
    }

    private List<MergerToken> createTokens() {
        ArrayList<MergerToken> tokens = new ArrayList<MergerToken>();
        for (AbstractMerger<?, ?> merger : this.mergerList) {
            tokens.addAll(merger.createMergeTokens());
        }
        Collections.sort(tokens);
        return tokens;
    }

    private void createDbEntityMerger(DataMap original, DataMap imported) {
        this.dbEntityMerger = new DbEntityMerger(this.tokenFactory, original, imported, this.filters, this.skipPKTokens);
        this.mergerList.add(this.dbEntityMerger);
    }

    private void createAttributeMerger() {
        ChainMerger<DbEntity, DbAttribute> dbAttributeMerger = new ChainMerger<DbEntity, DbAttribute>(this.tokenFactory, new DbAttributeMerger(this.tokenFactory, this.valueForNull), this.dbEntityMerger);
        this.mergerList.add(dbAttributeMerger);
    }

    private void createRelationshipMerger() {
        ChainMerger<DbEntity, DbRelationship> dbRelationshipMerger = new ChainMerger<DbEntity, DbRelationship>(this.tokenFactory, new DbRelationshipMerger(this.tokenFactory, this.skipRelationshipsTokens), this.dbEntityMerger);
        this.mergerList.add(dbRelationshipMerger);
    }

    public static Builder builder(MergerTokenFactory tokenFactory) {
        return new Builder(tokenFactory);
    }

    public static DataMapMerger build(MergerTokenFactory tokenFactory) {
        return DataMapMerger.builder(tokenFactory).build();
    }

    public static class Builder {
        private DataMapMerger merger = new DataMapMerger();

        private Builder(MergerTokenFactory tokenFactory) {
            this.merger.tokenFactory = Objects.requireNonNull(tokenFactory);
        }

        public DataMapMerger build() {
            if (this.merger.valueForNull == null) {
                this.merger.valueForNull = new EmptyValueForNullProvider();
            }
            if (this.merger.filters == null) {
                this.merger.filters = FiltersConfig.create(null, null, TableFilter.everything(), PatternFilter.INCLUDE_NOTHING);
            }
            return this.merger;
        }

        public Builder valueForNullProvider(ValueForNullProvider provider) {
            this.merger.valueForNull = provider;
            return this;
        }

        public Builder skipRelationshipsTokens(boolean flag) {
            this.merger.skipRelationshipsTokens = flag;
            return this;
        }

        public Builder skipPKTokens(boolean flag) {
            this.merger.skipPKTokens = flag;
            return this;
        }

        public Builder filters(FiltersConfig filters) {
            this.merger.filters = Objects.requireNonNull(filters);
            return this;
        }
    }
}

