/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.parser.ParseException;
import org.apache.cayenne.util.Util;

class ParserUtil {
    ParserUtil() {
    }

    static Object makeEnum(String enumPath) throws ParseException {
        Class<?> enumClass;
        if (enumPath == null) {
            throw new ParseException("Null 'enumPath'");
        }
        int dot = enumPath.lastIndexOf(46);
        if (dot <= 0 || dot == enumPath.length() - 1) {
            throw new ParseException("Invalid enum path: " + enumPath);
        }
        String className = enumPath.substring(0, dot);
        String enumName = enumPath.substring(dot + 1);
        try {
            enumClass = Util.getJavaClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Enum class not found: " + className);
        }
        if (!enumClass.isEnum()) {
            throw new ParseException("Specified class is not an enum: " + className);
        }
        try {
            return Enum.valueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid enum path: " + enumPath);
        }
    }
}

