/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class ClassGeneratorResourceLoader
extends FileResourceLoader {
    @Override
    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream stream = this.loadFromRelativePath(name);
        if (stream != null) {
            return stream;
        }
        stream = this.loadFromAbsPath(name);
        if (stream != null) {
            return stream;
        }
        stream = this.loadFromThreadClassLoader(name);
        if (stream != null) {
            return stream;
        }
        stream = this.loadFromThisClassLoader(name);
        if (stream != null) {
            return stream;
        }
        throw new ResourceNotFoundException("Couldn't find resource '" + name + "'. Searched filesystem path and classpath");
    }

    protected InputStream loadFromRelativePath(String name) {
        try {
            return super.getResourceStream(name);
        }
        catch (ResourceNotFoundException rnfex) {
            return null;
        }
    }

    protected InputStream loadFromAbsPath(String name) {
        try {
            File file = new File(name);
            return file.canRead() ? new BufferedInputStream(new FileInputStream(file.getAbsolutePath())) : null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    protected InputStream loadFromThreadClassLoader(String name) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
    }

    protected InputStream loadFromThisClassLoader(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }
}

