/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;

public class ProjectTreeFactory {
    public static DefaultMutableTreeNode wrapProjectNode(ConfigurationNode node) {
        return node.acceptVisitor(new TreeWrapper());
    }

    private static class TreeWrapper
    extends BaseConfigurationNodeVisitor<DefaultMutableTreeNode> {
        private LinkedList<DefaultMutableTreeNode> stack = new LinkedList();

        TreeWrapper() {
        }

        private <T extends Comparable<T>> Collection<T> sort(Collection<T> unsorted) {
            if (unsorted.size() < 2) {
                return unsorted;
            }
            ArrayList<T> sorted = new ArrayList<T>(unsorted);
            Collections.sort(sorted);
            return sorted;
        }

        private DefaultMutableTreeNode makeNode(Object object) {
            if (object == null) {
                throw new NullPointerException("Null object");
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(object);
            if (!this.stack.isEmpty()) {
                this.stack.getLast().add(node);
            }
            return node;
        }

        private DefaultMutableTreeNode pushNode(Object object) {
            DefaultMutableTreeNode node = this.makeNode(object);
            this.stack.add(node);
            return node;
        }

        private DefaultMutableTreeNode popNode() {
            return this.stack.removeLast();
        }

        @Override
        public DefaultMutableTreeNode visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
            this.pushNode(channelDescriptor);
            for (DataMap map : this.sort(channelDescriptor.getDataMaps())) {
                map.acceptVisitor(this);
            }
            for (DataNodeDescriptor node : this.sort(channelDescriptor.getNodeDescriptors())) {
                node.acceptVisitor(this);
            }
            return this.popNode();
        }

        @Override
        public DefaultMutableTreeNode visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
            DefaultMutableTreeNode parentNode;
            DataChannelDescriptor parent = null;
            if (!this.stack.isEmpty() && (parentNode = this.stack.getLast()).getUserObject() instanceof DataChannelDescriptor) {
                parent = (DataChannelDescriptor)parentNode.getUserObject();
            }
            this.pushNode(nodeDescriptor);
            if (parent != null) {
                ArrayList<String> mapNames = new ArrayList<String>(nodeDescriptor.getDataMapNames());
                Collections.sort(mapNames);
                for (String mapName : mapNames) {
                    this.makeNode(parent.getDataMap(mapName));
                }
            }
            return this.popNode();
        }

        @Override
        public DefaultMutableTreeNode visitDataMap(DataMap dataMap) {
            this.pushNode(dataMap);
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                this.makeNode(objEntity);
            }
            for (Embeddable embeddable : dataMap.getEmbeddables()) {
                this.makeNode(embeddable);
            }
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                this.makeNode(dbEntity);
            }
            for (Procedure procedure : dataMap.getProcedures()) {
                this.makeNode(procedure);
            }
            for (QueryDescriptor queryDescriptor : dataMap.getQueryDescriptors()) {
                this.makeNode(queryDescriptor);
            }
            return this.popNode();
        }
    }
}

