/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.commons.collections.map.LRUMap;

public class MapQueryCache
implements QueryCache,
Serializable {
    public static final int DEFAULT_CACHE_SIZE = 1000;
    static final String DEFAULT_CACHE_NAME = "cayenne.default.cache";
    protected final Map<String, Map<String, List<?>>> cacheGroups = new ConcurrentHashMap();
    private int maxSize;

    public MapQueryCache() {
        this(1000);
    }

    public MapQueryCache(int maxSize) {
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List get(QueryMetadata metadata) {
        Map<String, List<?>> map;
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        Map<String, List<?>> map2 = map = this.createIfAbsent(metadata);
        synchronized (map2) {
            return map.get(key);
        }
    }

    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        List result = this.get(metadata);
        if (result == null) {
            List newObject = factory.createObject();
            if (newObject == null) {
                throw new CayenneRuntimeException("Null on cache rebuilding: %s", metadata.getCacheKey());
            }
            result = newObject;
            this.put(metadata, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(QueryMetadata metadata, List results) {
        Map<String, List<?>> map;
        String key = metadata.getCacheKey();
        if (key == null) {
            return;
        }
        Map<String, List<?>> map2 = map = this.createIfAbsent(metadata);
        synchronized (map2) {
            map.put(key, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        if (key == null) {
            return;
        }
        Iterator<Map<String, List<?>>> iterator = this.cacheGroups.values().iterator();
        while (iterator.hasNext()) {
            Map<String, List<?>> map;
            Map<String, List<?>> map2 = map = iterator.next();
            synchronized (map2) {
                map.remove(key);
            }
        }
    }

    @Override
    public void removeGroup(String groupKey) {
        if (groupKey != null) {
            this.cacheGroups.remove(groupKey);
        }
    }

    @Override
    public void removeGroup(String groupKey, Class<?> keyType, Class<?> valueType) {
        this.removeGroup(groupKey);
    }

    @Override
    public void clear() {
        this.cacheGroups.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        Iterator<Map<String, List<?>>> iterator = this.cacheGroups.values().iterator();
        while (iterator.hasNext()) {
            Map<String, List<?>> map;
            Map<String, List<?>> map2 = map = iterator.next();
            synchronized (map2) {
                size += map.size();
            }
        }
        return size;
    }

    protected Map<String, List<?>> createIfAbsent(QueryMetadata metadata) {
        return this.createIfAbsent(this.cacheName(metadata));
    }

    protected Map<String, List<?>> createIfAbsent(String cacheName) {
        Map<String, List<?>> cache = this.getCache(cacheName);
        if (cache == null) {
            cache = this.createCache(cacheName);
        }
        return cache;
    }

    protected synchronized Map<String, List<?>> createCache(String cacheName) {
        LRUMap map = this.getCache(cacheName);
        if (map != null) {
            return map;
        }
        map = new LRUMap(this.maxSize);
        this.cacheGroups.put(cacheName, (Map<String, List<?>>)map);
        return map;
    }

    protected Map<String, List<?>> getCache(String name) {
        return this.cacheGroups.get(name);
    }

    protected String cacheName(QueryMetadata metadata) {
        String cacheGroup = metadata.getCacheGroup();
        if (cacheGroup != null) {
            return cacheGroup;
        }
        return DEFAULT_CACHE_NAME;
    }
}

