/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.DefaultQuotingStrategy;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.mysql.MySQLActionBuilder;
import org.apache.cayenne.dba.mysql.MySQLEJBQLTranslatorFactory;
import org.apache.cayenne.dba.mysql.MySQLPkGenerator;
import org.apache.cayenne.dba.mysql.MySQLQualifierTranslator;
import org.apache.cayenne.dba.mysql.MySQLSelectTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.resource.ResourceLocator;

public class MySQLAdapter
extends JdbcAdapter {
    static final String DEFAULT_STORAGE_ENGINE = "InnoDB";
    static final String MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_START = "`";
    static final String MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_END = "`";
    protected String storageEngine = "InnoDB";

    public MySQLAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    protected QuotingStrategy createQuotingStrategy() {
        return new DefaultQuotingStrategy("`", "`");
    }

    @Override
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return new MySQLSelectTranslator(query, this, entityResolver);
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        MySQLQualifierTranslator translator = new MySQLQualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new MySQLActionBuilder(node));
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        StringBuilder buf = new StringBuilder();
        QuotingStrategy context = this.getQuotingStrategy();
        buf.append(context.quotedFullyQualifiedName(table));
        return Arrays.asList("SET FOREIGN_KEY_CHECKS=0", "DROP TABLE IF EXISTS " + buf.toString() + " CASCADE", "SET FOREIGN_KEY_CHECKS=1");
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(false, false));
        map.registerType(new ByteArrayType(false, false));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (typeName != null) {
            typeName = typeName.toLowerCase();
        }
        if (type == 1111) {
            if ("longblob".equals(typeName)) {
                type = 2004;
            } else if ("mediumblob".equals(typeName)) {
                type = 2004;
            } else if ("blob".equals(typeName)) {
                type = 2004;
            } else if ("tinyblob".equals(typeName)) {
                type = -3;
            } else if ("longtext".equals(typeName)) {
                type = 2005;
            } else if ("mediumtext".equals(typeName)) {
                type = 2005;
            } else if ("text".equals(typeName)) {
                type = 2005;
            } else if ("tinytext".equals(typeName)) {
                type = 12;
            }
        } else if (typeName != null && typeName.endsWith(" unsigned") && (typeName.equals("int unsigned") || typeName.equals("integer unsigned") || typeName.equals("mediumint unsigned"))) {
            type = -5;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws SQLException, Exception {
        binding.setJdbcType(this.mapNTypes(binding.getJdbcType()));
        super.bindParameter(statement, binding);
    }

    private int mapNTypes(int sqlType) {
        switch (sqlType) {
            case -15: {
                return 1;
            }
            case 2011: {
                return 2005;
            }
            case -9: {
                return 12;
            }
            case -16: {
                return -1;
            }
        }
        return sqlType;
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new MySQLPkGenerator(this);
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        MySQLEJBQLTranslatorFactory translatorFactory = new MySQLEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public String createTable(DbEntity entity) {
        String ddlSQL = super.createTable(entity);
        if (this.storageEngine != null) {
            ddlSQL = ddlSQL + " ENGINE=" + this.storageEngine;
        }
        return ddlSQL;
    }

    @Override
    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        ArrayList<DbAttribute> pkList = new ArrayList<DbAttribute>(entity.getPrimaryKeys());
        Collections.sort(pkList, new PKComparator());
        Iterator pkit = pkList.iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                sqlBuffer.append(this.quotingStrategy.quotedName(at));
            }
            sqlBuffer.append(')');
        }
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? column.getEntity().getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '%s.%s': %s", entityName, column.getName(), column.getType());
        }
        String type = types[0];
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ').append(type);
        if (this.typeSupportsLength(column.getType())) {
            int scale;
            int len = column.getMaxLength();
            int n = scale = TypesMapping.isDecimal(column.getType()) ? column.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : " NULL");
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    @Override
    public boolean typeSupportsLength(int type) {
        switch (type) {
            case 92: 
            case 93: {
                return true;
            }
        }
        return super.typeSupportsLength(type);
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public void setStorageEngine(String engine) {
        this.storageEngine = engine;
    }

    final class PKComparator
    implements Comparator<DbAttribute> {
        PKComparator() {
        }

        @Override
        public int compare(DbAttribute a1, DbAttribute a2) {
            if (a1.isGenerated() != a2.isGenerated()) {
                return a1.isGenerated() ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

