/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.lifecycle.relationship.ObjectIdBatchFault;
import org.apache.cayenne.lifecycle.relationship.ObjectIdBatchSourceItem;
import org.apache.cayenne.lifecycle.relationship.ObjectIdFault;
import org.apache.cayenne.lifecycle.relationship.ObjectIdRelationship;
import org.apache.cayenne.lifecycle.relationship.ObjectIdRelationshipFaultingStrategy;

public class ObjectIdRelationshipBatchFaultingStrategy
implements ObjectIdRelationshipFaultingStrategy {
    private ThreadLocal<List<ObjectIdBatchSourceItem>> batchSources = new ThreadLocal();

    @Override
    public void afterObjectLoaded(DataObject object) {
        String uuidProperty = this.objectIdPropertyName(object);
        String uuidRelationship = this.objectIdRelationshipName(uuidProperty);
        String uuid = (String)object.readProperty(uuidProperty);
        if (uuid == null) {
            object.writePropertyDirectly(uuidRelationship, null);
        } else {
            List<ObjectIdBatchSourceItem> sources = this.batchSources.get();
            if (sources == null) {
                sources = new ArrayList<ObjectIdBatchSourceItem>();
                this.batchSources.set(sources);
            }
            sources.add(new ObjectIdBatchSourceItem(object, uuid, uuidRelationship));
        }
    }

    @Override
    public void afterQuery() {
        List<ObjectIdBatchSourceItem> sources = this.batchSources.get();
        if (sources != null) {
            this.batchSources.set(null);
            ObjectIdBatchFault batchFault = new ObjectIdBatchFault(sources.get(0).getObject().getObjectContext(), sources);
            for (ObjectIdBatchSourceItem source : sources) {
                source.getObject().writePropertyDirectly(source.getObjectIdRelationship(), (Object)new ObjectIdFault(batchFault, source.getId()));
            }
        }
    }

    String objectIdRelationshipName(String uuidPropertyName) {
        return "cay:related:" + uuidPropertyName;
    }

    String objectIdPropertyName(DataObject object) {
        ObjectIdRelationship annotation = object.getClass().getAnnotation(ObjectIdRelationship.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Object class is not annotated with @UuidRelationship: " + object.getClass().getName());
        }
        return annotation.value();
    }
}

