/*
 * Decompiled with CFR 0.152.
 */
package foundrylogic.vpp;

import foundrylogic.vpp.VPPContext;
import foundrylogic.vpp.VPPEngine;
import java.io.File;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class VPPConfig
extends DataType {
    private VPPContext vppContext;
    private VPPEngine vppEngine;
    private File tempDir;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private boolean useTempFile = false;
    private boolean keep = false;
    private static String DEFAULT_KEY = "VPPConfig.DEFAULT_KEY";

    public VPPConfig() {
        this.tempDir = new File("vpp.out");
    }

    public void addConfiguredContext(VPPContext vPPContext) {
        this.vppContext = vPPContext;
    }

    public void addConfiguredEngine(VPPEngine vPPEngine) {
        this.vppEngine = vPPEngine;
    }

    public VelocityContext getVelocityContext() {
        if (this.vppContext == null) {
            this.vppContext = new VPPContext();
            this.vppContext.setProject(this.getProject());
        }
        return this.vppContext.getVelocityContext();
    }

    public VelocityEngine getVelocityEngine() {
        if (this.vppEngine == null) {
            this.vppEngine = new VPPEngine();
            this.vppEngine.setProject(this.getProject());
        }
        return this.vppEngine.getVelocityEngine();
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File file) {
        this.tempDir = file;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    public void setUseTempFile(boolean bl) {
        this.useTempFile = bl;
        if (bl) {
            this.getProject().addBuildListener(new BuildListener(){

                public void buildStarted(BuildEvent buildEvent) {
                }

                public void buildFinished(BuildEvent buildEvent) {
                    if (!VPPConfig.this.keep && VPPConfig.this.tempDir.exists()) {
                        FileSet fileSet = new FileSet();
                        fileSet.setDir(VPPConfig.this.tempDir);
                        PatternSet.NameEntry nameEntry = fileSet.createInclude();
                        nameEntry.setName("**");
                        Delete delete = new Delete();
                        delete.setTaskName("vppconfig");
                        delete.setProject(VPPConfig.this.getProject());
                        delete.setIncludeEmptyDirs(true);
                        delete.setFailOnError(false);
                        delete.setVerbose(false);
                        delete.addFileset(fileSet);
                        delete.execute();
                    }
                }

                public void targetStarted(BuildEvent buildEvent) {
                }

                public void targetFinished(BuildEvent buildEvent) {
                }

                public void taskStarted(BuildEvent buildEvent) {
                }

                public void taskFinished(BuildEvent buildEvent) {
                }

                public void messageLogged(BuildEvent buildEvent) {
                }
            });
        }
    }

    public boolean isKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setRefid(Reference reference) {
        Object object = reference.getReferencedObject(this.getProject());
        if (!(object instanceof VPPConfig)) {
            String string = reference.getRefId() + " does not refer to a VPPConfig";
            throw new BuildException(string);
        }
        VPPConfig vPPConfig = (VPPConfig)((Object)object);
        this.vppContext = vPPConfig.vppContext;
        this.vppEngine = vPPConfig.vppEngine;
        this.tempDir = vPPConfig.tempDir;
        this.fileUtils = vPPConfig.fileUtils;
        this.useTempFile = vPPConfig.useTempFile;
        this.keep = vPPConfig.keep;
        super.setRefid(reference);
    }

    public static VPPConfig getDefaultConfig(Project project) {
        Object object = project.getReference(DEFAULT_KEY);
        if (object == null) {
            VPPConfig vPPConfig = new VPPConfig();
            vPPConfig.setProject(project);
            project.addReference(DEFAULT_KEY, (Object)vPPConfig);
            return vPPConfig;
        }
        if (object instanceof VPPConfig) {
            return (VPPConfig)((Object)object);
        }
        throw new BuildException("referenced object is not a VPPConfig");
    }
}

