/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.frontbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.util.DoNothingOperationObserver;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;

public class FrontBasePkGenerator
extends JdbcPkGenerator {
    public FrontBasePkGenerator(JdbcAdapter adapter) {
        super(adapter);
        this.pkStartValue = 1000000L;
    }

    @Override
    public int getPkCacheSize() {
        return 0;
    }

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        for (DbEntity entity : dbEntities) {
            this.runUpdate(node, this.pkCreateString(entity.getName()));
        }
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        for (DbEntity entity : dbEntities) {
            list.add(this.pkCreateString(entity.getName()));
        }
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
    }

    @Override
    protected String pkTableCreateString() {
        return "";
    }

    @Override
    protected String pkDeleteString(List<DbEntity> dbEntities) {
        return "-- The 'Drop Primary Key Support' option is unavailable";
    }

    @Override
    protected String pkCreateString(String entName) {
        StringBuilder buf = new StringBuilder();
        buf.append("SET UNIQUE = ").append(this.pkStartValue).append(" FOR \"").append(entName).append("\"");
        return buf.toString();
    }

    @Override
    protected String pkSelectString(String entName) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT UNIQUE FROM \"").append(entName).append("\"");
        return buf.toString();
    }

    @Override
    protected String pkUpdateString(String entName) {
        return "";
    }

    @Override
    protected String dropAutoPkString() {
        return "";
    }

    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        String template = "SELECT #result('UNIQUE' 'long') FROM " + entity.getName();
        final long[] pkHolder = new long[1];
        SQLTemplate query = new SQLTemplate(entity, template);
        DoNothingOperationObserver observer = new DoNothingOperationObserver(){

            @Override
            public void nextRows(Query query, List<?> dataRows) {
                if (dataRows.size() != 1) {
                    throw new CayenneRuntimeException("Error fetching PK. Expected one row, got %d", dataRows.size());
                }
                DataRow row = (DataRow)dataRows.get(0);
                Number pk = (Number)row.get("UNIQUE");
                pkHolder[0] = pk.longValue();
            }
        };
        node.performQueries(Collections.singleton(query), observer);
        return pkHolder[0];
    }
}

