/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Dialog;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.DbActionOptionsDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBWizardAction<T extends DbActionOptionsDialog>
extends CayenneAction {
    private static Logger LOGGER = LoggerFactory.getLogger(DBWizardAction.class);

    public DBWizardAction(String name, Application application) {
        super(name, application);
    }

    protected DataSourceWizard dataSourceWizardDialog(String title) {
        DataSourceWizard connectWizard = new DataSourceWizard(this.getProjectController(), title);
        if (!connectWizard.startupAction()) {
            return null;
        }
        return connectWizard;
    }

    protected abstract T createDialog(Collection<String> var1, Collection<String> var2, String var3, String var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T loaderOptionDialog(DataSourceWizard connectWizard) {
        String currentCatalog;
        List<String> schemas;
        List<String> catalogs;
        String currentSchema = null;
        try (Connection connection = connectWizard.getDataSource().getConnection();){
            catalogs = this.getCatalogs(connectWizard, connection);
            schemas = this.getSchemas(connection);
            if (catalogs.isEmpty() && schemas.isEmpty()) {
                T t = null;
                return t;
            }
            currentCatalog = connection.getCatalog();
            try {
                currentSchema = connection.getSchema();
            }
            catch (Throwable th) {
                LOGGER.warn("Error getting schema.", th);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading schemas dialog", 0);
            return null;
        }
        T optionsDialog = this.createDialog(catalogs, schemas, currentCatalog, currentSchema);
        ((Dialog)optionsDialog).setVisible(true);
        if (((DbActionOptionsDialog)optionsDialog).getChoice() != 1) return null;
        return optionsDialog;
    }

    private List<String> getCatalogs(DataSourceWizard connectWizard, Connection connection) throws Exception {
        if (!connectWizard.getAdapter().supportsCatalogsOnReverseEngineering()) {
            return Collections.EMPTY_LIST;
        }
        return DbLoader.loadCatalogs(connection);
    }

    private List<String> getSchemas(Connection connection) throws Exception {
        return DbLoader.loadSchemas(connection);
    }
}

