/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.client;

import java.io.IOException;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.RaftClientRpcWithProxy;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.util.PeerProxyMap;

public class NettyClientRpc
extends RaftClientRpcWithProxy<NettyRpcProxy> {
    public NettyClientRpc(ClientId clientId, RaftProperties properties) {
        super((PeerProxyMap)new NettyRpcProxy.PeerMap(clientId.toString(), properties));
    }

    public RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftProtos.RaftRpcRequestProto rpcRequest;
        RaftPeerId serverId = request.getServerId();
        NettyRpcProxy proxy = (NettyRpcProxy)this.getProxies().getProxy(serverId);
        NettyProtos.RaftNettyServerRequestProto.Builder b = NettyProtos.RaftNettyServerRequestProto.newBuilder();
        if (request instanceof GroupManagementRequest) {
            RaftProtos.GroupManagementRequestProto proto = ClientProtoUtils.toGroupManagementRequestProto((GroupManagementRequest)((GroupManagementRequest)request));
            b.setGroupManagementRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof SetConfigurationRequest) {
            RaftProtos.SetConfigurationRequestProto proto = ClientProtoUtils.toSetConfigurationRequestProto((SetConfigurationRequest)((SetConfigurationRequest)request));
            b.setSetConfigurationRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof GroupListRequest) {
            RaftProtos.GroupListRequestProto proto = ClientProtoUtils.toGroupListRequestProto((GroupListRequest)((GroupListRequest)request));
            b.setGroupListRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof GroupInfoRequest) {
            RaftProtos.GroupInfoRequestProto proto = ClientProtoUtils.toGroupInfoRequestProto((GroupInfoRequest)((GroupInfoRequest)request));
            b.setGroupInfoRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof TransferLeadershipRequest) {
            RaftProtos.TransferLeadershipRequestProto proto = ClientProtoUtils.toTransferLeadershipRequestProto((TransferLeadershipRequest)((TransferLeadershipRequest)request));
            b.setTransferLeadershipRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof SnapshotManagementRequest) {
            RaftProtos.SnapshotManagementRequestProto proto = ClientProtoUtils.toSnapshotManagementRequestProto((SnapshotManagementRequest)((SnapshotManagementRequest)request));
            b.setSnapshotManagementRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof LeaderElectionManagementRequest) {
            RaftProtos.LeaderElectionManagementRequestProto proto = ClientProtoUtils.toLeaderElectionManagementRequestProto((LeaderElectionManagementRequest)((LeaderElectionManagementRequest)request));
            b.setLeaderElectionManagementRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else {
            RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto((RaftClientRequest)request);
            b.setRaftClientRequest(proto);
            rpcRequest = proto.getRpcRequest();
        }
        if (request instanceof GroupListRequest) {
            return ClientProtoUtils.toGroupListReply((RaftProtos.GroupListReplyProto)proxy.send(rpcRequest, b.build()).getGroupListReply());
        }
        if (request instanceof GroupInfoRequest) {
            return ClientProtoUtils.toGroupInfoReply((RaftProtos.GroupInfoReplyProto)proxy.send(rpcRequest, b.build()).getGroupInfoReply());
        }
        return ClientProtoUtils.toRaftClientReply((RaftProtos.RaftClientReplyProto)proxy.send(rpcRequest, b.build()).getRaftClientReply());
    }
}

