/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.identity.UserIdentifier$;
import org.apache.celeborn.common.meta.AppDiskUsage;
import org.apache.celeborn.common.meta.AppDiskUsageSnapShot;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbAppDiskUsage;
import org.apache.celeborn.common.protocol.PbAppDiskUsageSnapshot;
import org.apache.celeborn.common.protocol.PbDiskInfo;
import org.apache.celeborn.common.protocol.PbFileInfo;
import org.apache.celeborn.common.protocol.PbFileInfoMap;
import org.apache.celeborn.common.protocol.PbPartitionLocation;
import org.apache.celeborn.common.protocol.PbResourceConsumption;
import org.apache.celeborn.common.protocol.PbSnapshotMetaInfo;
import org.apache.celeborn.common.protocol.PbSortedShuffleFileSet;
import org.apache.celeborn.common.protocol.PbStoreVersion;
import org.apache.celeborn.common.protocol.PbUserIdentifier;
import org.apache.celeborn.common.protocol.PbWorkerInfo;
import org.apache.celeborn.common.protocol.PbWorkerResource;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.CollectionUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.protobuf.InvalidProtocolBufferException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PbSerDeUtils$ {
    public static PbSerDeUtils$ MODULE$;

    static {
        new PbSerDeUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> fromPbSortedShuffleFileSet(byte[] data) throws InvalidProtocolBufferException {
        void var3_3;
        PbSortedShuffleFileSet pbSortedShuffleFileSet = PbSortedShuffleFileSet.parseFrom(data);
        ConcurrentHashMap.KeySetView<String, Boolean> files = ConcurrentHashMap.newKeySet();
        files.addAll(pbSortedShuffleFileSet.getFilesList());
        return var3_3;
    }

    public byte[] toPbSortedShuffleFileSet(Set<String> files) {
        return PbSortedShuffleFileSet.newBuilder().addAllFiles(files).build().toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Integer> fromPbStoreVersion(byte[] data) throws InvalidProtocolBufferException {
        void var3_3;
        PbStoreVersion pbStoreVersion = PbStoreVersion.parseFrom(data);
        ArrayList<Integer> versions = new ArrayList<Integer>();
        versions.add(Predef$.MODULE$.int2Integer(pbStoreVersion.getMajor()));
        versions.add(Predef$.MODULE$.int2Integer(pbStoreVersion.getMinor()));
        return var3_3;
    }

    public byte[] toPbStoreVersion(int major, int minor) {
        return PbStoreVersion.newBuilder().setMajor(major).setMinor(minor).build().toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public DiskInfo fromPbDiskInfo(PbDiskInfo pbDiskInfo) {
        void var2_2;
        DiskInfo diskInfo = new DiskInfo(pbDiskInfo.getMountPoint(), pbDiskInfo.getUsableSpace(), pbDiskInfo.getAvgFlushTime(), pbDiskInfo.getAvgFetchTime(), pbDiskInfo.getUsedSlots()).setStatus(Utils$.MODULE$.toDiskStatus(pbDiskInfo.getStatus()));
        diskInfo.setStorageType(StorageInfo.typesMap.get(BoxesRunTime.boxToInteger((int)pbDiskInfo.getStorageType())));
        return var2_2;
    }

    public PbDiskInfo toPbDiskInfo(DiskInfo diskInfo) {
        return PbDiskInfo.newBuilder().setMountPoint(diskInfo.mountPoint()).setUsableSpace(diskInfo.actualUsableSpace()).setAvgFlushTime(diskInfo.avgFlushTime()).setAvgFetchTime(diskInfo.avgFetchTime()).setUsedSlots(diskInfo.activeSlots()).setStatus(diskInfo.status().getValue()).setStorageType(diskInfo.storageType().getValue()).build();
    }

    public FileInfo fromPbFileInfo(PbFileInfo pbFileInfo) {
        return this.fromPbFileInfo(pbFileInfo, this.fromPbUserIdentifier(pbFileInfo.getUserIdentifier()));
    }

    public FileInfo fromPbFileInfo(PbFileInfo pbFileInfo, UserIdentifier userIdentifier) {
        return new FileInfo(pbFileInfo.getFilePath(), pbFileInfo.getChunkOffsetsList(), userIdentifier, Utils$.MODULE$.toPartitionType(pbFileInfo.getPartitionType()), pbFileInfo.getBufferSize(), pbFileInfo.getNumSubpartitions(), pbFileInfo.getBytesFlushed(), pbFileInfo.getPartitionSplitEnabled());
    }

    public PbFileInfo toPbFileInfo(FileInfo fileInfo) {
        return PbFileInfo.newBuilder().setFilePath(fileInfo.getFilePath()).addAllChunkOffsets(fileInfo.getChunkOffsets()).setUserIdentifier(this.toPbUserIdentifier(fileInfo.getUserIdentifier())).setPartitionType(fileInfo.getPartitionType().getValue()).setBufferSize(fileInfo.getBufferSize()).setNumSubpartitions(fileInfo.getNumSubpartitions()).setBytesFlushed(fileInfo.getFileLength()).setPartitionSplitEnabled(fileInfo.isPartitionSplitEnabled()).build();
    }

    public ConcurrentHashMap<String, FileInfo> fromPbFileInfoMap(byte[] data, ConcurrentHashMap<String, UserIdentifier> cache) throws InvalidProtocolBufferException {
        PbFileInfoMap pbFileInfoMap = PbFileInfoMap.parseFrom(data);
        ConcurrentHashMap<String, FileInfo> fileInfoMap = JavaUtils.newConcurrentHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(pbFileInfoMap.getValuesMap().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            FileInfo fileInfo;
            String fileName = (String)entry.getKey();
            PbFileInfo pbFileInfo = (PbFileInfo)entry.getValue();
            PbUserIdentifier pbUserIdentifier = pbFileInfo.getUserIdentifier();
            String userIdentifierKey = new StringBuilder(1).append(pbUserIdentifier.getTenantId()).append("-").append(pbUserIdentifier.getName()).toString();
            if (!cache.containsKey(userIdentifierKey)) {
                FileInfo fileInfo2 = MODULE$.fromPbFileInfo(pbFileInfo);
                cache.put(userIdentifierKey, fileInfo2.getUserIdentifier());
                fileInfo = fileInfoMap.put(fileName, fileInfo2);
            } else {
                FileInfo fileInfo3 = MODULE$.fromPbFileInfo(pbFileInfo, (UserIdentifier)cache.get(userIdentifierKey));
                fileInfo = fileInfoMap.put(fileName, fileInfo3);
            }
            return fileInfo;
        });
        return fileInfoMap;
    }

    public byte[] toPbFileInfoMap(ConcurrentHashMap<String, FileInfo> fileInfoMap) {
        ConcurrentHashMap<String, PbFileInfo> pbFileInfoMap = JavaUtils.newConcurrentHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(fileInfoMap.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> pbFileInfoMap.put((String)entry.getKey(), MODULE$.toPbFileInfo((FileInfo)entry.getValue())));
        return PbFileInfoMap.newBuilder().putAllValues(pbFileInfoMap).build().toByteArray();
    }

    public UserIdentifier fromPbUserIdentifier(PbUserIdentifier pbUserIdentifier) {
        return new UserIdentifier(pbUserIdentifier.getTenantId(), pbUserIdentifier.getName());
    }

    public PbUserIdentifier toPbUserIdentifier(UserIdentifier userIdentifier) {
        return PbUserIdentifier.newBuilder().setTenantId(userIdentifier.tenantId()).setName(userIdentifier.name()).build();
    }

    public ResourceConsumption fromPbResourceConsumption(PbResourceConsumption pbResourceConsumption) {
        return new ResourceConsumption(pbResourceConsumption.getDiskBytesWritten(), pbResourceConsumption.getDiskFileCount(), pbResourceConsumption.getHdfsBytesWritten(), pbResourceConsumption.getHdfsFileCount(), this.fromPbSubResourceConsumptions(pbResourceConsumption.getSubResourceConsumptionsMap()));
    }

    public PbResourceConsumption toPbResourceConsumption(ResourceConsumption resourceConsumption) {
        return PbResourceConsumption.newBuilder().setDiskBytesWritten(resourceConsumption.diskBytesWritten()).setDiskFileCount(resourceConsumption.diskFileCount()).setHdfsBytesWritten(resourceConsumption.hdfsBytesWritten()).setHdfsFileCount(resourceConsumption.hdfsFileCount()).putAllSubResourceConsumptions(this.toPbSubResourceConsumptions(resourceConsumption.subResourceConsumptions())).build();
    }

    public Map<String, ResourceConsumption> fromPbSubResourceConsumptions(Map<String, PbResourceConsumption> pbSubResourceConsumptions) {
        return CollectionUtils.isEmpty(pbSubResourceConsumptions) ? null : (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbSubResourceConsumptions).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            PbResourceConsumption pbResourceConsumption = (PbResourceConsumption)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)MODULE$.fromPbResourceConsumption(pbResourceConsumption));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<String, PbResourceConsumption> toPbSubResourceConsumptions(Map<String, ResourceConsumption> subResourceConsumptions) {
        return CollectionUtils.isEmpty(subResourceConsumptions) ? new HashMap<String, PbResourceConsumption>() : (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(subResourceConsumptions).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)MODULE$.toPbResourceConsumption(resourceConsumption));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<UserIdentifier, ResourceConsumption> fromPbUserResourceConsumption(Map<String, PbResourceConsumption> pbUserResourceConsumption) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbUserResourceConsumption).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String userIdentifierString = (String)tuple2._1();
            PbResourceConsumption pbResourceConsumption = (PbResourceConsumption)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)UserIdentifier$.MODULE$.apply(userIdentifierString), (Object)MODULE$.fromPbResourceConsumption(pbResourceConsumption));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<String, PbResourceConsumption> toPbUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(userResourceConsumption).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
            ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)userIdentifier.toString(), (Object)MODULE$.toPbResourceConsumption(resourceConsumption));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public WorkerInfo fromPbWorkerInfo(PbWorkerInfo pbWorkerInfo) {
        ConcurrentHashMap<String, DiskInfo> disks = JavaUtils.newConcurrentHashMap();
        if (pbWorkerInfo.getDisksCount() > 0) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerInfo.getDisksList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)pbDiskInfo -> disks.put(pbDiskInfo.getMountPoint(), MODULE$.fromPbDiskInfo((PbDiskInfo)pbDiskInfo)));
        }
        Map<UserIdentifier, ResourceConsumption> userResourceConsumption = this.fromPbUserResourceConsumption(pbWorkerInfo.getUserResourceConsumptionMap());
        return new WorkerInfo(pbWorkerInfo.getHost(), pbWorkerInfo.getRpcPort(), pbWorkerInfo.getPushPort(), pbWorkerInfo.getFetchPort(), pbWorkerInfo.getReplicatePort(), disks, userResourceConsumption);
    }

    public PbWorkerInfo toPbWorkerInfo(WorkerInfo workerInfo, boolean eliminateUserResourceConsumption) {
        Collection<DiskInfo> diskInfos = workerInfo.diskInfos().values();
        ArrayList pbDiskInfos = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(diskInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)pbDiskInfos.add(PbSerDeUtils$.MODULE$.toPbDiskInfo(diskInfo))));
        PbWorkerInfo.Builder builder = PbWorkerInfo.newBuilder().setHost(workerInfo.host()).setRpcPort(workerInfo.rpcPort()).setFetchPort(workerInfo.fetchPort()).setPushPort(workerInfo.pushPort()).setReplicatePort(workerInfo.replicatePort()).addAllDisks(pbDiskInfos);
        Object object = !eliminateUserResourceConsumption ? builder.putAllUserResourceConsumption(this.toPbUserResourceConsumption(workerInfo.userResourceConsumption())) : BoxedUnit.UNIT;
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public PartitionLocation fromPbPartitionLocation(PbPartitionLocation pbLoc) {
        void var3_3;
        block2: {
            PartitionLocation.Mode mode = PartitionLocation.Mode.PRIMARY;
            if (pbLoc.getMode().equals(PbPartitionLocation.Mode.Replica)) {
                mode = PartitionLocation.Mode.REPLICA;
            }
            PartitionLocation partitionLocation = new PartitionLocation(pbLoc.getId(), pbLoc.getEpoch(), pbLoc.getHost(), pbLoc.getRpcPort(), pbLoc.getPushPort(), pbLoc.getFetchPort(), pbLoc.getReplicatePort(), mode, null, StorageInfo.fromPb(pbLoc.getStorageInfo()), Utils$.MODULE$.byteStringToRoaringBitmap(pbLoc.getMapIdBitmap()));
            if (!pbLoc.hasPeer()) break block2;
            PbPartitionLocation peerPb = pbLoc.getPeer();
            PartitionLocation.Mode peerMode = PartitionLocation.Mode.PRIMARY;
            if (peerPb.getMode() == PbPartitionLocation.Mode.Replica) {
                peerMode = PartitionLocation.Mode.REPLICA;
            }
            PartitionLocation peerLocation = new PartitionLocation(peerPb.getId(), peerPb.getEpoch(), peerPb.getHost(), peerPb.getRpcPort(), peerPb.getPushPort(), peerPb.getFetchPort(), peerPb.getReplicatePort(), peerMode, partitionLocation, StorageInfo.fromPb(peerPb.getStorageInfo()), Utils$.MODULE$.byteStringToRoaringBitmap(peerPb.getMapIdBitmap()));
            partitionLocation.setPeer(peerLocation);
        }
        return var3_3;
    }

    public PbPartitionLocation toPbPartitionLocation(PartitionLocation location) {
        Object object;
        PbPartitionLocation.Builder builder = PbPartitionLocation.newBuilder();
        PbPartitionLocation.Builder builder2 = location.getMode() == PartitionLocation.Mode.PRIMARY ? builder.setMode(PbPartitionLocation.Mode.Primary) : builder.setMode(PbPartitionLocation.Mode.Replica);
        builder.setHost(location.getHost()).setEpoch(location.getEpoch()).setId(location.getId()).setRpcPort(location.getRpcPort()).setPushPort(location.getPushPort()).setFetchPort(location.getFetchPort()).setReplicatePort(location.getReplicatePort()).setStorageInfo(StorageInfo.toPb(location.getStorageInfo())).setMapIdBitmap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
        if (location.hasPeer()) {
            PbPartitionLocation.Builder peerBuilder = PbPartitionLocation.newBuilder();
            PbPartitionLocation.Builder builder3 = location.getPeer().getMode() == PartitionLocation.Mode.PRIMARY ? peerBuilder.setMode(PbPartitionLocation.Mode.Primary) : peerBuilder.setMode(PbPartitionLocation.Mode.Replica);
            peerBuilder.setHost(location.getPeer().getHost()).setEpoch(location.getPeer().getEpoch()).setId(location.getPeer().getId()).setRpcPort(location.getPeer().getRpcPort()).setPushPort(location.getPeer().getPushPort()).setFetchPort(location.getPeer().getFetchPort()).setReplicatePort(location.getPeer().getReplicatePort()).setStorageInfo(StorageInfo.toPb(location.getPeer().getStorageInfo())).setMapIdBitmap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
            object = builder.setPeer(peerBuilder.build());
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> fromPbWorkerResource(Map<String, PbWorkerResource> pbWorkerResource) {
        void var2_2;
        HashMap slots = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbWorkerResource).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple5 tuple5;
            PbWorkerResource pbWorkerResource;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String uniqueId = (String)tuple2._1();
                pbWorkerResource = (PbWorkerResource)tuple2._2();
                String[] stringArray = uniqueId.split(":");
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(5) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String host = (String)((SeqLike)option.get()).apply(0);
                String rpcPort = (String)((SeqLike)option.get()).apply(1);
                String pushPort = (String)((SeqLike)option.get()).apply(2);
                String fetchPort = (String)((SeqLike)option.get()).apply(3);
                String replicatePort = (String)((SeqLike)option.get()).apply(4);
                tuple5 = new Tuple5((Object)host, (Object)rpcPort, (Object)pushPort, (Object)fetchPort, (Object)replicatePort);
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple5 tuple52 = tuple5;
            String host = (String)tuple52._1();
            String rpcPort = (String)tuple52._2();
            String pushPort = (String)tuple52._3();
            String fetchPort = (String)tuple52._4();
            String replicatePort = (String)tuple52._5();
            String networkLocation = pbWorkerResource.getNetworkLocation();
            WorkerInfo workerInfo = new WorkerInfo(host, new StringOps(Predef$.MODULE$.augmentString(rpcPort)).toInt(), new StringOps(Predef$.MODULE$.augmentString(pushPort)).toInt(), new StringOps(Predef$.MODULE$.augmentString(fetchPort)).toInt(), new StringOps(Predef$.MODULE$.augmentString(replicatePort)).toInt());
            workerInfo.networkLocation_$eq(networkLocation);
            ArrayList primaryPartitionLocation = new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerResource.getPrimaryPartitionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).asJava());
            ArrayList replicaPartitionLocation = new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerResource.getReplicaPartitionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).asJava());
            Tuple2 tuple22 = slots.put(workerInfo, new Tuple2(primaryPartitionLocation, replicaPartitionLocation));
            return tuple22;
        });
        return var2_2;
    }

    public Map<String, PbWorkerResource> toPbWorkerResource(HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> workerResource) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(workerResource).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            WorkerInfo workerInfo;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    workerInfo = (WorkerInfo)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            List primaryLocations = (List)tuple2._1();
            List replicaLocations = (List)tuple2._2();
            List primaryPartitions = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).asJava();
            List replicaPartitions = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).asJava();
            PbWorkerResource pbWorkerResource = PbWorkerResource.newBuilder().addAllPrimaryPartitions(primaryPartitions).addAllReplicaPartitions(replicaPartitions).setNetworkLocation(workerInfo.networkLocation()).build();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)workerInfo.toUniqueId()), (Object)pbWorkerResource);
            return tuple23;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public AppDiskUsage fromPbAppDiskUsage(PbAppDiskUsage pbAppDiskUsage) {
        return new AppDiskUsage(pbAppDiskUsage.getAppId(), pbAppDiskUsage.getEstimatedUsage());
    }

    public PbAppDiskUsage toPbAppDiskUsage(AppDiskUsage appDiskUsage) {
        return PbAppDiskUsage.newBuilder().setAppId(appDiskUsage.appId()).setEstimatedUsage(appDiskUsage.estimatedUsage()).build();
    }

    /*
     * WARNING - void declaration
     */
    public AppDiskUsageSnapShot fromPbAppDiskUsageSnapshot(PbAppDiskUsageSnapshot pbAppDiskUsageSnapShot) {
        void var2_2;
        AppDiskUsageSnapShot snapShot = new AppDiskUsageSnapShot(pbAppDiskUsageSnapShot.getTopItemCount());
        snapShot.startSnapShotTime_$eq(pbAppDiskUsageSnapShot.getStartSnapShotTime());
        snapShot.endSnapShotTime_$eq(pbAppDiskUsageSnapShot.getEndSnapshotTime());
        snapShot.restoreFromSnapshot((AppDiskUsage[])((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbAppDiskUsageSnapShot.getTopNItemsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbAppDiskUsage -> MODULE$.fromPbAppDiskUsage((PbAppDiskUsage)pbAppDiskUsage), Buffer$.MODULE$.canBuildFrom())).asJava()).stream().toArray((IntFunction<A[]>)new IntFunction<AppDiskUsage[]>(){

            public AppDiskUsage[] apply(int value) {
                return new AppDiskUsage[value];
            }
        }));
        return var2_2;
    }

    public PbAppDiskUsageSnapshot toPbAppDiskUsageSnapshot(AppDiskUsageSnapShot snapshots) {
        return PbAppDiskUsageSnapshot.newBuilder().setTopItemCount(snapshots.topItemCount()).setStartSnapShotTime(snapshots.startSnapShotTime()).setEndSnapshotTime(snapshots.endSnapShotTime()).addAllTopNItems((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshots.topNItems())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PbSerDeUtils$.$anonfun$toPbAppDiskUsageSnapshot$1(x$2))))).map((Function1 & Serializable & scala.Serializable)appDiskUsage -> MODULE$.toPbAppDiskUsage((AppDiskUsage)appDiskUsage), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PbAppDiskUsage.class))))).toList()).asJava()).build();
    }

    public PbSnapshotMetaInfo toPbSnapshotMetaInfo(Long estimatedPartitionSize, Set<String> registeredShuffle, Set<String> hostnameSet, Set<WorkerInfo> excludedWorkers, Set<WorkerInfo> manuallyExcludedWorkers, Set<WorkerInfo> workerLostEvent, Map<String, Long> appHeartbeatTime, List<WorkerInfo> workers, Long partitionTotalWritten, Long partitionTotalFileCount, AppDiskUsageSnapShot[] appDiskUsageMetricSnapshots, AppDiskUsageSnapShot currentAppDiskUsageMetricsSnapshot, ConcurrentHashMap<WorkerInfo, Long> lostWorkers, Set<WorkerInfo> shutdownWorkers) {
        PbSnapshotMetaInfo.Builder builder = PbSnapshotMetaInfo.newBuilder().setEstimatedPartitionSize(Predef$.MODULE$.Long2long(estimatedPartitionSize)).addAllRegisteredShuffle(registeredShuffle).addAllHostnameSet(hostnameSet).addAllExcludedWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(excludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$3, true), Set$.MODULE$.canBuildFrom())).asJava()).addAllManuallyExcludedWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(manuallyExcludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$4, true), Set$.MODULE$.canBuildFrom())).asJava()).addAllWorkerLostEvents((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(workerLostEvent).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$5, true), Set$.MODULE$.canBuildFrom())).asJava()).putAllAppHeartbeatTime(appHeartbeatTime).addAllWorkers((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(workers).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$6, true), Buffer$.MODULE$.canBuildFrom())).asJava()).setPartitionTotalWritten(Predef$.MODULE$.Long2long(partitionTotalWritten)).setPartitionTotalFileCount(Predef$.MODULE$.Long2long(partitionTotalFileCount)).addAllAppDiskUsageMetricSnapshots((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appDiskUsageMetricSnapshots)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PbSerDeUtils$.$anonfun$toPbSnapshotMetaInfo$5(x$7))))).map((Function1 & Serializable & scala.Serializable)snapshots -> MODULE$.toPbAppDiskUsageSnapshot((AppDiskUsageSnapShot)snapshots), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PbAppDiskUsageSnapshot.class))))).toList()).asJava()).putAllLostWorkers((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(lostWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo workerInfo;
            Long time;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    WorkerInfo worker = (WorkerInfo)tuple2._1();
                    time = (Long)tuple2._2();
                    if (worker == null) break block2;
                    workerInfo = worker;
                    if (time != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Long l = time;
            Tuple2 tuple2 = new Tuple2((Object)workerInfo.toUniqueId(), (Object)l);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava()).addAllShutdownWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(shutdownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$8, true), Set$.MODULE$.canBuildFrom())).asJava());
        Object object = currentAppDiskUsageMetricsSnapshot != null ? builder.setCurrentAppDiskUsageMetricsSnapshot(this.toPbAppDiskUsageSnapshot(currentAppDiskUsageMetricsSnapshot)) : BoxedUnit.UNIT;
        return builder.build();
    }

    public static final /* synthetic */ boolean $anonfun$toPbAppDiskUsageSnapshot$1(AppDiskUsage x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toPbSnapshotMetaInfo$5(AppDiskUsageSnapShot x$7) {
        return x$7 != null;
    }

    private PbSerDeUtils$() {
        MODULE$ = this;
    }
}

