/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.shuffledb;

import com.google.common.base.Throwables;
import java.io.IOException;
import org.apache.celeborn.service.deploy.worker.shuffledb.DB;
import org.apache.celeborn.service.deploy.worker.shuffledb.DBIterator;
import org.apache.celeborn.service.deploy.worker.shuffledb.RocksDBIterator;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksDB
implements DB {
    private final org.rocksdb.RocksDB db;
    private final WriteOptions SYNC_WRITE_OPTIONS = new WriteOptions().setSync(true);

    public RocksDB(org.rocksdb.RocksDB db) {
        this.db = db;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        try {
            this.db.put(key, value);
        }
        catch (RocksDBException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void put(byte[] key, byte[] value, boolean sync) {
        try {
            if (sync) {
                this.db.put(this.SYNC_WRITE_OPTIONS, key, value);
            } else {
                this.db.put(key, value);
            }
        }
        catch (RocksDBException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void delete(byte[] key) {
        try {
            this.db.delete(key);
        }
        catch (RocksDBException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public DBIterator iterator() {
        return new RocksDBIterator(this.db.newIterator());
    }

    @Override
    public void close() throws IOException {
        this.db.close();
    }
}

