/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.FileAlwaysReloadingStrategy;
import org.apache.commons.configuration.reloading.FileRandomReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.MergeCombiner;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.apache.commons.configuration.tree.UnionCombiner;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestCombinedConfiguration {
    private static final String TEST_NAME = "SUBCONFIG";
    private static final String TEST_KEY = "test.value";
    private static final String CHILD1 = "SUBCONFIG1";
    private static final String CHILD2 = "SUBCONFIG2";
    private static final String RELOAD_XML_NAME = "reload.xml";
    private static final String RELOAD_XML_CONTENT = "<xml><xmlReload>{0}</xmlReload></xml>";
    private static final String RELOAD_PROPS_NAME = "reload.properties";
    private static final String RELOAD_PROPS_CONTENT = "propsReload = {0}";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private CombinedConfiguration config;
    private CombinedListener listener;

    @Before
    public void setUp() throws Exception {
        this.config = new CombinedConfiguration();
        this.listener = new CombinedListener();
        this.config.addConfigurationListener((ConfigurationListener)this.listener);
    }

    @Test
    public void testInit() {
        Assert.assertEquals((String)"Already configurations contained", (long)0L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Set of names is not empty", (boolean)this.config.getConfigurationNames().isEmpty());
        Assert.assertTrue((String)"Wrong node combiner", (boolean)(this.config.getNodeCombiner() instanceof UnionCombiner));
        Assert.assertNull((String)"Test config was found", (Object)this.config.getConfiguration(TEST_NAME));
        Assert.assertFalse((String)"Force reload check flag is set", (boolean)this.config.isForceReloadCheck());
    }

    @Test
    public void testAddConfiguration() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c);
        this.checkAddConfig(c);
        Assert.assertEquals((String)"Wrong number of configs", (long)1L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Name list is not empty", (boolean)this.config.getConfigurationNames().isEmpty());
        Assert.assertSame((String)"Added config not found", (Object)c, (Object)this.config.getConfiguration(0));
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean(TEST_KEY));
        this.listener.checkEvent(1, 0);
    }

    @Test
    public void testAddConfigurationWithName() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c, TEST_NAME);
        this.checkAddConfig(c);
        Assert.assertEquals((String)"Wrong number of configs", (long)1L, (long)this.config.getNumberOfConfigurations());
        Assert.assertSame((String)"Added config not found", (Object)c, (Object)this.config.getConfiguration(0));
        Assert.assertSame((String)"Added config not found by name", (Object)c, (Object)this.config.getConfiguration(TEST_NAME));
        Set names = this.config.getConfigurationNames();
        Assert.assertEquals((String)"Wrong number of config names", (long)1L, (long)names.size());
        Assert.assertTrue((String)"Name not found", (boolean)names.contains(TEST_NAME));
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean(TEST_KEY));
        this.listener.checkEvent(1, 0);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testAddConfigurationWithNameTwice() {
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME);
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME, "prefix");
    }

    @Test
    public void testAddConfigurationAt() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c, null, "my");
        this.checkAddConfig(c);
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean("my.test.value"));
    }

    @Test
    public void testAddConfigurationComplexAt() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c, null, "This..is.a.complex");
        this.checkAddConfig(c);
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean("This..is.a.complex.test.value"));
    }

    private void checkAddConfig(AbstractConfiguration c) {
        Collection listeners = c.getConfigurationListeners();
        Assert.assertEquals((String)"Wrong number of configuration listeners", (long)1L, (long)listeners.size());
        Assert.assertTrue((String)"Combined config is no listener", (boolean)listeners.contains(this.config));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullConfiguration() {
        this.config.addConfiguration(null);
    }

    @Test
    public void testAccessPropertyEmpty() {
        Assert.assertFalse((String)"Found a key", (boolean)this.config.containsKey(TEST_KEY));
        Assert.assertNull((String)"Key has a value", (Object)this.config.getString("test.comment"));
        Assert.assertTrue((String)"Config is not empty", (boolean)this.config.isEmpty());
    }

    @Test
    public void testAccessPropertyMulti() {
        this.config.addConfiguration(this.setUpTestConfiguration());
        this.config.addConfiguration(this.setUpTestConfiguration(), null, "prefix1");
        this.config.addConfiguration(this.setUpTestConfiguration(), null, "prefix2");
        Assert.assertTrue((String)"Prop1 not found", (boolean)this.config.getBoolean(TEST_KEY));
        Assert.assertTrue((String)"Prop 2 not found", (boolean)this.config.getBoolean("prefix1.test.value"));
        Assert.assertTrue((String)"Prop 3 not found", (boolean)this.config.getBoolean("prefix2.test.value"));
        Assert.assertFalse((String)"Configuration is empty", (boolean)this.config.isEmpty());
        this.listener.checkEvent(3, 0);
    }

    @Test
    public void testRemoveConfiguration() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c);
        this.checkAddConfig(c);
        Assert.assertTrue((String)"Config could not be removed", (boolean)this.config.removeConfiguration((Configuration)c));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveConfigurationAt() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c);
        Assert.assertSame((String)"Wrong config removed", (Object)c, (Object)this.config.removeConfigurationAt(0));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveConfigurationByName() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c, TEST_NAME);
        Assert.assertSame((String)"Wrong config removed", (Object)c, (Object)this.config.removeConfiguration(TEST_NAME));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveNamedConfiguration() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c, TEST_NAME);
        this.config.removeConfiguration((Configuration)c);
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveNamedConfigurationAt() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c, TEST_NAME);
        Assert.assertSame((String)"Wrong config removed", (Object)c, (Object)this.config.removeConfigurationAt(0));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveNonContainedConfiguration() {
        Assert.assertFalse((String)"Could remove non contained config", (boolean)this.config.removeConfiguration((Configuration)this.setUpTestConfiguration()));
        this.listener.checkEvent(0, 0);
    }

    @Test
    public void testRemoveConfigurationByUnknownName() {
        Assert.assertNull((String)"Could remove configuration by unknown name", (Object)this.config.removeConfiguration("unknownName"));
        this.listener.checkEvent(0, 0);
    }

    private void checkRemoveConfig(AbstractConfiguration c) {
        Assert.assertTrue((String)"Listener was not removed", (boolean)c.getConfigurationListeners().isEmpty());
        Assert.assertEquals((String)"Wrong number of contained configs", (long)0L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Name was not removed", (boolean)this.config.getConfigurationNames().isEmpty());
        this.listener.checkEvent(2, 0);
    }

    @Test
    public void testUpdateContainedConfiguration() {
        AbstractConfiguration c = this.setUpTestConfiguration();
        this.config.addConfiguration(c);
        c.addProperty("test.otherTest", (Object)"yes");
        Assert.assertEquals((String)"New property not found", (Object)"yes", (Object)this.config.getString("test.otherTest"));
        this.listener.checkEvent(2, 0);
    }

    @Test
    public void testSetNodeCombiner() {
        UnionCombiner combiner = new UnionCombiner();
        this.config.setNodeCombiner((NodeCombiner)combiner);
        Assert.assertSame((String)"Node combiner was not set", (Object)combiner, (Object)this.config.getNodeCombiner());
        this.listener.checkEvent(1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNullNodeCombiner() {
        this.config.setNodeCombiner(null);
    }

    @Test
    public void testClone() {
        this.config.addConfiguration(this.setUpTestConfiguration());
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME, "conf2");
        this.config.addConfiguration((AbstractConfiguration)new PropertiesConfiguration(), "props");
        CombinedConfiguration cc2 = (CombinedConfiguration)this.config.clone();
        Assert.assertEquals((String)"Wrong number of contained configurations", (long)this.config.getNumberOfConfigurations(), (long)cc2.getNumberOfConfigurations());
        Assert.assertSame((String)"Wrong node combiner", (Object)this.config.getNodeCombiner(), (Object)cc2.getNodeCombiner());
        Assert.assertEquals((String)"Wrong number of names", (long)this.config.getConfigurationNames().size(), (long)cc2.getConfigurationNames().size());
        Assert.assertTrue((String)"Event listeners were cloned", (boolean)cc2.getConfigurationListeners().isEmpty());
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        for (int i = 0; i < this.config.getNumberOfConfigurations(); ++i) {
            Assert.assertNotSame((String)("Configuration at " + i + " was not cloned"), (Object)this.config.getConfiguration(i), (Object)cc2.getConfiguration(i));
            Assert.assertEquals((String)("Wrong config class at " + i), this.config.getConfiguration(i).getClass(), cc2.getConfiguration(i).getClass());
            Assert.assertTrue((String)("Configs not equal at " + i), (boolean)comp.compare(this.config.getConfiguration(i), cc2.getConfiguration(i)));
        }
        Assert.assertTrue((String)"Combined configs not equal", (boolean)comp.compare((Configuration)this.config, (Configuration)cc2));
    }

    @Test
    public void testCloneModify() {
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME);
        CombinedConfiguration cc2 = (CombinedConfiguration)this.config.clone();
        Assert.assertTrue((String)"Name is missing", (boolean)cc2.getConfigurationNames().contains(TEST_NAME));
        cc2.removeConfiguration(TEST_NAME);
        Assert.assertFalse((String)"Names in original changed", (boolean)this.config.getConfigurationNames().isEmpty());
    }

    @Test
    public void testClear() {
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME, "test");
        this.config.addConfiguration(this.setUpTestConfiguration());
        this.config.clear();
        Assert.assertEquals((String)"Still configs contained", (long)0L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Still names contained", (boolean)this.config.getConfigurationNames().isEmpty());
        Assert.assertTrue((String)"Config is not empty", (boolean)this.config.isEmpty());
        this.listener.checkEvent(3, 2);
    }

    @Test
    public void testReloading() throws Exception {
        this.config.setForceReloadCheck(true);
        File testXmlFile = this.writeReloadFile(RELOAD_XML_NAME, RELOAD_XML_CONTENT, 0);
        File testPropsFile = this.writeReloadFile(RELOAD_PROPS_NAME, RELOAD_PROPS_CONTENT, 0);
        XMLConfiguration c1 = new XMLConfiguration(testXmlFile);
        c1.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        PropertiesConfiguration c2 = new PropertiesConfiguration(testPropsFile);
        c2.setThrowExceptionOnMissing(true);
        c2.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        this.config.addConfiguration((AbstractConfiguration)c1);
        this.config.addConfiguration((AbstractConfiguration)c2);
        Assert.assertEquals((String)"Wrong xml reload value", (long)0L, (long)this.config.getInt("xmlReload"));
        Assert.assertEquals((String)"Wrong props reload value", (long)0L, (long)this.config.getInt("propsReload"));
        this.writeReloadFile(RELOAD_XML_NAME, RELOAD_XML_CONTENT, 1);
        Assert.assertEquals((String)"XML reload not detected", (long)1L, (long)this.config.getInt("xmlReload"));
        this.config.setForceReloadCheck(false);
        this.writeReloadFile(RELOAD_PROPS_NAME, RELOAD_PROPS_CONTENT, 1);
        Assert.assertEquals((String)"Props reload detected though check flag is false", (long)0L, (long)this.config.getInt("propsReload"));
    }

    @Test
    public void testReloadingSubnodeConfig() throws IOException, ConfigurationException {
        this.config.setForceReloadCheck(true);
        File testXmlFile = this.writeReloadFile(RELOAD_XML_NAME, RELOAD_XML_CONTENT, 0);
        XMLConfiguration c1 = new XMLConfiguration(testXmlFile);
        c1.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        String prefix = "reloadCheck";
        this.config.addConfiguration((AbstractConfiguration)c1, CHILD1, "reloadCheck");
        SubnodeConfiguration sub = this.config.configurationAt("reloadCheck", true);
        this.writeReloadFile(RELOAD_XML_NAME, RELOAD_XML_CONTENT, 1);
        Assert.assertEquals((String)"Reload not detected", (long)1L, (long)sub.getInt("xmlReload"));
    }

    @Test
    public void testReloadingNestedCC() throws IOException, ConfigurationException {
        this.config.setForceReloadCheck(true);
        File testXmlFile = this.writeReloadFile(RELOAD_XML_NAME, RELOAD_XML_CONTENT, 0);
        File testPropsFile = this.writeReloadFile(RELOAD_PROPS_NAME, RELOAD_PROPS_CONTENT, 0);
        XMLConfiguration c1 = new XMLConfiguration(testXmlFile);
        c1.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        PropertiesConfiguration c2 = new PropertiesConfiguration(testPropsFile);
        c2.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        this.config.addConfiguration((AbstractConfiguration)c2);
        CombinedConfiguration cc2 = new CombinedConfiguration();
        cc2.setForceReloadCheck(true);
        cc2.addConfiguration((AbstractConfiguration)c1);
        this.config.addConfiguration((AbstractConfiguration)cc2);
        Assert.assertEquals((String)"Wrong xml reload value", (long)0L, (long)this.config.getInt("xmlReload"));
        this.writeReloadFile(RELOAD_XML_NAME, RELOAD_XML_CONTENT, 1);
        Assert.assertEquals((String)"XML reload not detected", (long)1L, (long)this.config.getInt("xmlReload"));
    }

    private void setUpSourceTest() {
        HierarchicalConfiguration c1 = new HierarchicalConfiguration();
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c1.addProperty(TEST_KEY, (Object)TEST_NAME);
        c2.addProperty("another.key", (Object)"test");
        this.config.addConfiguration((AbstractConfiguration)c1, CHILD1);
        this.config.addConfiguration((AbstractConfiguration)c2, CHILD2);
    }

    @Test
    public void testGetSourceHierarchical() {
        this.setUpSourceTest();
        Assert.assertEquals((String)"Wrong source configuration", (Object)this.config.getConfiguration(CHILD1), (Object)this.config.getSource(TEST_KEY));
    }

    @Test
    public void testGetSourceNonHierarchical() {
        this.setUpSourceTest();
        Assert.assertEquals((String)"Wrong source configuration", (Object)this.config.getConfiguration(CHILD2), (Object)this.config.getSource("another.key"));
    }

    @Test
    public void testGetSourceUnknown() {
        this.setUpSourceTest();
        Assert.assertNull((String)"Wrong result for unknown key", (Object)this.config.getSource("an.unknown.key"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSourceNull() {
        this.config.getSource(null);
    }

    @Test
    public void testGetSourceCombined() {
        this.setUpSourceTest();
        String key = "yet.another.key";
        this.config.addProperty("yet.another.key", (Object)Boolean.TRUE);
        Assert.assertEquals((String)"Wrong source for key", (Object)this.config, (Object)this.config.getSource("yet.another.key"));
    }

    @Test
    public void testGetSourceMulti() {
        this.setUpSourceTest();
        String key = "list.key";
        this.config.getConfiguration(CHILD1).addProperty("list.key", (Object)"1,2,3");
        Assert.assertEquals((String)"Wrong source for multi-value property", (Object)this.config.getConfiguration(CHILD1), (Object)this.config.getSource("list.key"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSourceMultiSources() {
        this.setUpSourceTest();
        String key = "list.key";
        this.config.getConfiguration(CHILD1).addProperty("list.key", (Object)"1,2,3");
        this.config.getConfiguration(CHILD2).addProperty("list.key", (Object)"a,b,c");
        this.config.getSource("list.key");
    }

    @Test
    public void testEscapeListDelimiters() {
        PropertiesConfiguration sub = new PropertiesConfiguration();
        sub.addProperty("test.pi", (Object)"3\\,1415");
        this.config.addConfiguration((AbstractConfiguration)sub);
        Assert.assertEquals((String)"Wrong value", (Object)"3,1415", (Object)this.config.getString("test.pi"));
    }

    @Test
    public void testInvalidateAfterChange() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this.config, 0, null, null, true);
        this.config.configurationChanged(event);
        Assert.assertEquals((String)"Invalidate event fired", (long)0L, (long)this.listener.invalidateEvents);
        event = new ConfigurationEvent((Object)this.config, 0, null, null, false);
        this.config.configurationChanged(event);
        Assert.assertEquals((String)"No invalidate event fired", (long)1L, (long)this.listener.invalidateEvents);
    }

    @Test
    public void testConversionExpressionEngine() {
        PropertiesConfiguration child = new PropertiesConfiguration();
        child.addProperty("test(a)", (Object)"1,2,3");
        this.config.addConfiguration((AbstractConfiguration)child);
        DefaultExpressionEngine engineQuery = new DefaultExpressionEngine();
        engineQuery.setIndexStart("<");
        engineQuery.setIndexEnd(">");
        this.config.setExpressionEngine((ExpressionEngine)engineQuery);
        DefaultExpressionEngine engineConvert = new DefaultExpressionEngine();
        engineConvert.setIndexStart("[");
        engineConvert.setIndexEnd("]");
        this.config.setConversionExpressionEngine((ExpressionEngine)engineConvert);
        Assert.assertEquals((String)"Wrong property 1", (Object)"1", (Object)this.config.getString("test(a)<0>"));
        Assert.assertEquals((String)"Wrong property 2", (Object)"2", (Object)this.config.getString("test(a)<1>"));
        Assert.assertEquals((String)"Wrong property 3", (Object)"3", (Object)this.config.getString("test(a)<2>"));
    }

    @Test
    public void testDeadlockWithReload() throws ConfigurationException, InterruptedException {
        final PropertiesConfiguration child = new PropertiesConfiguration("test.properties");
        child.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        this.config.addConfiguration((AbstractConfiguration)child);
        int count = 1000;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestDeadlockReloadThread
        extends Thread {
            boolean error = false;

            TestDeadlockReloadThread() {
            }

            @Override
            public void run() {
                for (int i = 0; i < 1000 && !this.error; ++i) {
                    try {
                        if (child.getBoolean("configuration.loaded")) continue;
                        this.error = true;
                        continue;
                    }
                    catch (NoSuchElementException nsex) {
                        this.error = true;
                    }
                }
            }
        }
        TestDeadlockReloadThread reloadThread = new TestDeadlockReloadThread();
        reloadThread.start();
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((String)"Wrong value of combined property", (long)10L, (long)this.config.getInt("test.integer"));
        }
        reloadThread.join();
        Assert.assertFalse((String)"Failure in thread", (boolean)reloadThread.error);
    }

    @Test
    public void testGetConfigurations() throws Exception {
        this.config.addConfiguration(this.setUpTestConfiguration());
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME, "conf2");
        PropertiesConfiguration pc = new PropertiesConfiguration();
        this.config.addConfiguration((AbstractConfiguration)pc, "props");
        List list = this.config.getConfigurations();
        Assert.assertNotNull((String)"No list of configurations returned", (Object)list);
        Assert.assertTrue((String)"Incorrect number of configurations", (list.size() == 3 ? 1 : 0) != 0);
        AbstractConfiguration c = (AbstractConfiguration)list.get(2);
        Assert.assertTrue((String)"Incorrect configuration", (c == pc ? 1 : 0) != 0);
    }

    @Test
    public void testGetConfigurationNameList() throws Exception {
        this.config.addConfiguration(this.setUpTestConfiguration());
        this.config.addConfiguration(this.setUpTestConfiguration(), TEST_NAME, "conf2");
        PropertiesConfiguration pc = new PropertiesConfiguration();
        this.config.addConfiguration((AbstractConfiguration)pc, "props");
        List list = this.config.getConfigurationNameList();
        Assert.assertNotNull((String)"No list of configurations returned", (Object)list);
        Assert.assertTrue((String)"Incorrect number of configurations", (list.size() == 3 ? 1 : 0) != 0);
        String name = (String)list.get(1);
        Assert.assertNotNull((String)"No name returned", (Object)name);
        Assert.assertTrue((String)"Incorrect configuration name", (boolean)TEST_NAME.equals(name));
    }

    @Test
    public void testReloadWithSubNodeConfig() throws Exception {
        String reloadContent = "<config><default><xmlReload1>{0}</xmlReload1></default></config>";
        this.config.setForceReloadCheck(true);
        this.config.setNodeCombiner((NodeCombiner)new OverrideCombiner());
        File testXmlFile1 = this.writeReloadFile(RELOAD_XML_NAME, "<config><default><xmlReload1>{0}</xmlReload1></default></config>", 0);
        String prefix1 = "default";
        XMLConfiguration c1 = new XMLConfiguration(testXmlFile1);
        SubnodeConfiguration sub1 = c1.configurationAt("default", true);
        Assert.assertEquals((String)"Inital test for sub config 1 failed", (long)0L, (long)sub1.getInt("xmlReload1"));
        this.config.addConfiguration((AbstractConfiguration)sub1);
        Assert.assertEquals((String)"Could not get value for sub config 1 from combined config", (long)0L, (long)this.config.getInt("xmlReload1"));
        c1.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        this.writeReloadFile(RELOAD_XML_NAME, "<config><default><xmlReload1>{0}</xmlReload1></default></config>", 1);
        Assert.assertEquals((String)"Reload of sub config 1 not detected", (long)1L, (long)this.config.getInt("xmlReload1"));
    }

    @Test
    public void testConcurrentGetAndReload() throws Exception {
        int threadCount = 5;
        int loopCount = 1000;
        this.config.setForceReloadCheck(true);
        this.config.setNodeCombiner((NodeCombiner)new MergeCombiner());
        XMLConfiguration xml = new XMLConfiguration("configA.xml");
        xml.setReloadingStrategy((ReloadingStrategy)new FileRandomReloadingStrategy());
        this.config.addConfiguration((AbstractConfiguration)xml);
        XMLConfiguration xml2 = new XMLConfiguration("configB.xml");
        xml2.setReloadingStrategy((ReloadingStrategy)new FileRandomReloadingStrategy());
        this.config.addConfiguration((AbstractConfiguration)xml2);
        this.config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assert.assertEquals((Object)this.config.getString("/property[@name='config']/@value"), (Object)"100");
        Thread[] testThreads = new Thread[5];
        int[] failures = new int[5];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(this.config, failures, i, 1000);
            testThreads[i].start();
        }
        int totalFailures = 0;
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        Assert.assertTrue((String)(totalFailures + " failures Occurred"), (totalFailures == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCombinedCopyToXML() throws ConfigurationException {
        XMLConfiguration x1 = new XMLConfiguration();
        x1.addProperty("key1", (Object)"value1");
        x1.addProperty("key1[@override]", (Object)"USER1");
        x1.addProperty("key2", (Object)"value2");
        x1.addProperty("key2[@override]", (Object)"USER2");
        XMLConfiguration x2 = new XMLConfiguration();
        x2.addProperty("key2", (Object)"value2.2");
        x2.addProperty("key2[@override]", (Object)"USER2");
        this.config.setNodeCombiner((NodeCombiner)new OverrideCombiner());
        this.config.addConfiguration((AbstractConfiguration)x2);
        this.config.addConfiguration((AbstractConfiguration)x1);
        XMLConfiguration x3 = new XMLConfiguration((HierarchicalConfiguration)this.config);
        Assert.assertEquals((String)"Wrong element value", (Object)"value2.2", (Object)x3.getString("key2"));
        Assert.assertEquals((String)"Wrong attribute value", (Object)"USER2", (Object)x3.getString("key2[@override]"));
        StringWriter w = new StringWriter();
        x3.save((Writer)w);
        String s = w.toString();
        x3 = new XMLConfiguration();
        x3.load((Reader)new StringReader(s));
        Assert.assertEquals((String)"Wrong element value after load", (Object)"value2.2", (Object)x3.getString("key2"));
        Assert.assertEquals((String)"Wrong attribute value after load", (Object)"USER2", (Object)x3.getString("key2[@override]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String content) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            out.print(content);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private File writeFile(String fileName, String content) throws IOException {
        File file = new File(this.folder.getRoot(), fileName);
        this.writeFile(file, content);
        return file;
    }

    private File writeReloadFile(String name, String content, int value) throws IOException {
        return this.writeFile(name, MessageFormat.format(content, new Integer(value)));
    }

    private AbstractConfiguration setUpTestConfiguration() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.addProperty(TEST_KEY, (Object)Boolean.TRUE);
        config.addProperty("test.comment", (Object)"This is a test");
        return config;
    }

    static class CombinedListener
    implements ConfigurationListener {
        int invalidateEvents;
        int otherEvents;

        CombinedListener() {
        }

        public void configurationChanged(ConfigurationEvent event) {
            if (event.getType() == 40) {
                ++this.invalidateEvents;
            } else {
                ++this.otherEvents;
            }
        }

        public void checkEvent(int expectedInvalidate, int expectedOthers) {
            junit.framework.Assert.assertEquals((String)"Wrong number of invalidate events", (int)expectedInvalidate, (int)this.invalidateEvents);
            junit.framework.Assert.assertEquals((String)"Wrong number of other events", (int)expectedOthers, (int)this.otherEvents);
        }
    }

    private class ReloadThread
    extends Thread {
        CombinedConfiguration combined;
        int[] failures;
        int index;
        int count;

        ReloadThread(CombinedConfiguration config, int[] failures, int index, int count) {
            this.combined = config;
            this.failures = failures;
            this.index = index;
            this.count = count;
        }

        public void run() {
            this.failures[this.index] = 0;
            for (int i = 0; i < this.count; ++i) {
                try {
                    String value = this.combined.getString("/property[@name='config']/@value");
                    if (value != null && value.equals("100")) continue;
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                    continue;
                }
                catch (Exception ex) {
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                }
            }
        }
    }
}

