/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.spherical.twod.BoundarySource2S;
import org.apache.commons.geometry.spherical.twod.ConvexArea2S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatArcPath;
import org.apache.commons.geometry.spherical.twod.InteriorAngleGreatArcConnector;
import org.apache.commons.geometry.spherical.twod.Point2S;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.numbers.core.Sum;

public class RegionBSPTree2S
extends AbstractRegionBSPTree<Point2S, RegionNode2S>
implements BoundarySource2S {
    private static final double FULL_SIZE = Math.PI * 4;
    private List<GreatArcPath> boundaryPaths;

    public RegionBSPTree2S() {
        this(false);
    }

    public RegionBSPTree2S(boolean full) {
        super(full);
    }

    public RegionBSPTree2S copy() {
        RegionBSPTree2S result = RegionBSPTree2S.empty();
        result.copy((BSPTree)this);
        return result;
    }

    public Iterable<GreatArc> boundaries() {
        return this.createBoundaryIterable(GreatArc.class::cast);
    }

    public Stream<GreatArc> boundaryStream() {
        return StreamSupport.stream(this.boundaries().spliterator(), false);
    }

    public List<GreatArc> getBoundaries() {
        return this.createBoundaryList(GreatArc.class::cast);
    }

    public List<GreatArcPath> getBoundaryPaths() {
        if (this.boundaryPaths == null) {
            this.boundaryPaths = Collections.unmodifiableList(this.computeBoundaryPaths());
        }
        return this.boundaryPaths;
    }

    public List<ConvexArea2S> toConvex() {
        ArrayList<ConvexArea2S> result = new ArrayList<ConvexArea2S>();
        this.toConvexRecursive((RegionNode2S)this.getRoot(), ConvexArea2S.full(), result);
        return result;
    }

    private void toConvexRecursive(RegionNode2S node, ConvexArea2S nodeArea, List<? super ConvexArea2S> result) {
        if (node.isLeaf()) {
            if (node.isInside()) {
                result.add(nodeArea);
            }
        } else {
            Split<ConvexArea2S> split = nodeArea.split((Hyperplane<Point2S>)node.getCutHyperplane());
            this.toConvexRecursive((RegionNode2S)node.getMinus(), (ConvexArea2S)split.getMinus(), result);
            this.toConvexRecursive((RegionNode2S)node.getPlus(), (ConvexArea2S)split.getPlus(), result);
        }
    }

    public Split<RegionBSPTree2S> split(Hyperplane<Point2S> splitter) {
        return this.split(splitter, RegionBSPTree2S.empty(), RegionBSPTree2S.empty());
    }

    public Point2S project(Point2S pt) {
        BoundaryProjector2S projector = new BoundaryProjector2S(pt);
        this.accept((BSPTreeVisitor)projector);
        return (Point2S)projector.getProjected();
    }

    @Override
    public RegionBSPTree2S toTree() {
        return this;
    }

    protected AbstractRegionBSPTree.RegionSizeProperties<Point2S> computeRegionSizeProperties() {
        if (this.isFull()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(Math.PI * 4, null);
        }
        if (this.isEmpty()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(0.0, null);
        }
        List<ConvexArea2S> areas = this.toConvex();
        Precision.DoubleEquivalence precision = ((GreatArc)((RegionNode2S)this.getRoot()).getCut()).getPrecision();
        Sum sizeSum = Sum.create();
        Vector3D.Sum centroidVectorSum = Vector3D.Sum.create();
        double maxCentroidVectorWeightSq = 0.0;
        for (ConvexArea2S area : areas) {
            sizeSum.add(area.getSize());
            Vector3D areaCentroidVector = area.getWeightedCentroidVector();
            maxCentroidVectorWeightSq = Math.max(maxCentroidVectorWeightSq, areaCentroidVector.normSq());
            centroidVectorSum.add(areaCentroidVector);
        }
        double size = sizeSum.getAsDouble();
        Vector3D centroidVector = centroidVectorSum.get();
        Point2S centroid = centroidVector.normSq() < maxCentroidVectorWeightSq && centroidVector.eq(Vector3D.ZERO, precision) ? null : Point2S.from(centroidVector);
        return new AbstractRegionBSPTree.RegionSizeProperties(size, (Point)centroid);
    }

    protected RegionNode2S createNode() {
        return new RegionNode2S((AbstractBSPTree)this);
    }

    protected void invalidate() {
        super.invalidate();
        this.boundaryPaths = null;
    }

    private List<GreatArcPath> computeBoundaryPaths() {
        InteriorAngleGreatArcConnector.Minimize connector = new InteriorAngleGreatArcConnector.Minimize();
        return connector.connectAll(this.boundaries());
    }

    public static RegionBSPTree2S empty() {
        return new RegionBSPTree2S(false);
    }

    public static RegionBSPTree2S full() {
        return new RegionBSPTree2S(true);
    }

    public static RegionBSPTree2S from(Iterable<GreatArc> boundaries) {
        return RegionBSPTree2S.from(boundaries, false);
    }

    public static RegionBSPTree2S from(Iterable<GreatArc> boundaries, boolean full) {
        RegionBSPTree2S tree = new RegionBSPTree2S(full);
        tree.insert(boundaries);
        return tree;
    }

    private static final class BoundaryProjector2S
    extends AbstractRegionBSPTree.BoundaryProjector<Point2S, RegionNode2S> {
        BoundaryProjector2S(Point2S point) {
            super((Point)point);
        }

        protected Point2S disambiguateClosestPoint(Point2S target, Point2S a, Point2S b) {
            int cmp = Point2S.POLAR_AZIMUTH_ASCENDING_ORDER.compare(a, b);
            return cmp < 0 ? a : b;
        }
    }

    public static final class RegionNode2S
    extends AbstractRegionBSPTree.AbstractRegionNode<Point2S, RegionNode2S> {
        private RegionNode2S(AbstractBSPTree<Point2S, RegionNode2S> tree) {
            super(tree);
        }

        public ConvexArea2S getNodeRegion() {
            RegionNode2S parent;
            ConvexArea2S area = ConvexArea2S.full();
            RegionNode2S child = this;
            while ((parent = (RegionNode2S)child.getParent()) != null) {
                Split<ConvexArea2S> split = area.split((Hyperplane<Point2S>)parent.getCutHyperplane());
                area = child.isMinus() ? (ConvexArea2S)split.getMinus() : (ConvexArea2S)split.getPlus();
                child = parent;
            }
            return area;
        }

        protected RegionNode2S getSelf() {
            return this;
        }
    }
}

