/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.oned;

import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.spherical.oned.Point1S;

public final class Transform1S
implements Transform<Point1S> {
    private static final Transform1S IDENTITY = new Transform1S(1.0, 0.0);
    private static final Transform1S NEGATION = new Transform1S(-1.0, 0.0);
    private final double scale;
    private final double rotate;

    private Transform1S(double scale, double rotate) {
        this.scale = scale;
        this.rotate = rotate;
    }

    public boolean isNegation() {
        return this.scale <= 0.0;
    }

    public double getRotation() {
        return this.rotate;
    }

    public Point1S apply(Point1S pt) {
        double az = pt.getAzimuth();
        double resultAz = az * this.scale + this.rotate;
        return Point1S.of(resultAz);
    }

    public boolean preservesOrientation() {
        return !this.isNegation();
    }

    public Transform1S rotate(double angle) {
        return this.premultiply(Transform1S.createRotation(angle));
    }

    public Transform1S negate() {
        return this.premultiply(Transform1S.createNegation());
    }

    public Transform1S multiply(Transform1S other) {
        return Transform1S.multiply(this, other);
    }

    public Transform1S premultiply(Transform1S other) {
        return Transform1S.multiply(other, this);
    }

    public Transform1S inverse() {
        double invScale = 1.0 / this.scale;
        double resultRotate = -(this.rotate * invScale);
        return new Transform1S(invScale, resultRotate);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + Double.hashCode(this.scale);
        result = result * 31 + Double.hashCode(this.rotate);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transform1S)) {
            return false;
        }
        Transform1S other = (Transform1S)obj;
        return Double.compare(this.scale, other.scale) == 0 && Double.compare(this.rotate, other.rotate) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[negate= ").append(this.isNegation()).append(", rotate= ").append(this.getRotation()).append(']');
        return sb.toString();
    }

    public static Transform1S identity() {
        return IDENTITY;
    }

    public static Transform1S createNegation() {
        return NEGATION;
    }

    public static Transform1S createRotation(double angle) {
        return new Transform1S(1.0, angle);
    }

    private static Transform1S multiply(Transform1S a, Transform1S b) {
        double resultScale = a.scale * b.scale;
        double resultRotate = a.scale * b.rotate + a.rotate;
        return new Transform1S(resultScale, resultRotate);
    }
}

