/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp;

import java.io.File;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.webp.AbstractWebPTest;
import org.apache.commons.imaging.formats.webp.WebPImageMetadata;
import org.apache.commons.imaging.formats.webp.WebPImageParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebPMetadataTest
extends AbstractWebPTest {
    @Test
    public void testReadAlpha() throws Exception {
        File imageFile = new File(WebPMetadataTest.class.getResource("/images/webp/alpha/alpha.webp").getFile());
        WebPImageParser parser = new WebPImageParser();
        ImageInfo imageInfo = parser.getImageInfo(ByteSource.file((File)imageFile), parser.getDefaultParameters());
        Assertions.assertNotNull((Object)imageInfo);
    }

    @Test
    public void testReadMetadata() throws Exception {
        File imageFile = new File(WebPMetadataTest.class.getResource("/images/webp/exif/_DSC6099.webp").getFile());
        WebPImageParser parser = new WebPImageParser();
        WebPImageMetadata metadata = parser.getMetadata(ByteSource.file((File)imageFile), parser.getDefaultParameters());
        Assertions.assertEquals((int)56, (int)metadata.getItems().size());
        TiffImageMetadata tiffImageMetadata = metadata.getExif();
        Assertions.assertNotNull((Object)tiffImageMetadata);
        TagInfoAscii make = new TagInfoAscii("", 271, 0, null);
        Object field = tiffImageMetadata.getFieldValue((TagInfo)make);
        Assertions.assertEquals((Object)"sony", (Object)field.toString().trim().toLowerCase());
    }

    @Test
    public void testReadXmp() throws Exception {
        File imageFile = new File(WebPMetadataTest.class.getResource("/images/webp/xmp/test.webp").getFile());
        WebPImageParser parser = new WebPImageParser();
        String xml = parser.getXmpXml(ByteSource.file((File)imageFile), (XmpImagingParameters)parser.getDefaultParameters());
        Assertions.assertTrue((boolean)xml.contains("Apache License"));
    }
}

