/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.RoundtripBase;
import org.apache.commons.imaging.roundtrip.TestImages;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class NullParametersRoundtripTest
extends RoundtripBase {
    public static Stream<FormatInfo> data() {
        return Stream.of(FormatInfo.READ_WRITE_FORMATS);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testNullParametersRoundtrip(FormatInfo formatInfo) throws Exception {
        byte[] temp1;
        BufferedImage testImage = TestImages.createFullColorImage(1, 1);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Imaging.writeImage((BufferedImage)testImage, (OutputStream)byteArrayOutputStream, (ImageFormat)formatInfo.format);
            temp1 = byteArrayOutputStream.toByteArray();
        }
        String fileName = "nullParameters." + formatInfo.format.getDefaultExtension();
        Imaging.getImageInfo((InputStream)new ByteArrayInputStream(temp1), (String)fileName);
        Imaging.getImageSize((InputStream)new ByteArrayInputStream(temp1), (String)fileName);
        Imaging.getMetadata((InputStream)new ByteArrayInputStream(temp1), (String)fileName);
        Imaging.getIccProfile((InputStream)new ByteArrayInputStream(temp1), (String)fileName);
        BufferedImage imageRead = Imaging.getBufferedImage((InputStream)new ByteArrayInputStream(temp1), (String)fileName);
        Assertions.assertNotNull((Object)imageRead);
    }
}

