/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.input.CloseShieldReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class CloseShieldReaderTest {
    private String data;
    private Reader original;
    private Reader shielded;

    CloseShieldReaderTest() {
    }

    @BeforeEach
    public void setUp() {
        this.data = "xyz";
        this.original = (Reader)Mockito.spy((Object)new CharSequenceReader((CharSequence)this.data));
        this.shielded = CloseShieldReader.wrap((Reader)this.original);
    }

    @Test
    void testClose() throws IOException {
        this.shielded.close();
        ((Reader)Mockito.verify((Object)this.original, (VerificationMode)Mockito.never())).close();
        char[] cbuf = new char[10];
        Assertions.assertEquals((int)-1, (int)this.shielded.read(cbuf, 0, 10), (String)"read(cbuf, off, len)");
        Assertions.assertEquals((int)this.data.length(), (int)this.original.read(cbuf, 0, 10), (String)"read(cbuf, off, len)");
        Assertions.assertEquals((Object)this.data, (Object)new String(cbuf, 0, this.data.length()));
    }
}

