/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.charset.CharsetDecoders;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WriterOutputStreamTest {
    private static final String UTF_16LE = StandardCharsets.UTF_16LE.name();
    private static final String UTF_16BE = StandardCharsets.UTF_16BE.name();
    private static final String UTF_16 = StandardCharsets.UTF_16.name();
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING = StringUtils.repeat((String)"\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre", (int)100);
    private final Random random = new Random();

    WriterOutputStreamTest() {
    }

    @Test
    void testFlush() throws IOException {
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024, false);){
            out.write("abc".getBytes(StandardCharsets.US_ASCII));
            Assertions.assertEquals((int)0, (int)writer.getBuffer().length());
            out.flush();
            Assertions.assertEquals((Object)"abc", (Object)writer.toString());
        }
    }

    @Test
    void testLargeUTF8CharsetWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(LARGE_TEST_STRING, UTF_8);
    }

    @Test
    void testLargeUTF8CharsetWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(LARGE_TEST_STRING, StandardCharsets.UTF_8);
    }

    @Test
    void testLargeUTF8WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(LARGE_TEST_STRING, UTF_8);
    }

    @Test
    void testLargeUTF8WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(LARGE_TEST_STRING, UTF_8);
    }

    @Test
    void testNullCharsetDecoderWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, (CharsetDecoder)null);
    }

    @Test
    void testNullCharsetNameWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, (String)null);
    }

    @Test
    void testNullCharsetWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, (Charset)null);
    }

    @Test
    void testUTF16BEWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, UTF_16BE);
    }

    @Test
    void testUTF16BEWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, UTF_16BE);
    }

    @Test
    void testUTF16LEWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, UTF_16LE);
    }

    @Test
    void testUTF16LEWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, UTF_16LE);
    }

    @Test
    void testUTF16WithBufferedWrite() throws IOException {
        block2: {
            try {
                this.testWithBufferedWrite(TEST_STRING, UTF_16);
            }
            catch (UnsupportedOperationException e) {
                if (SystemProperties.getJavaVendor().contains("IBM")) break block2;
                Assertions.fail((String)"This test should only throw UOE on IBM JDKs with broken UTF-16");
            }
        }
    }

    @Test
    void testUTF16WithSingleByteWrite() throws IOException {
        block2: {
            try {
                this.testWithSingleByteWrite(TEST_STRING, UTF_16);
            }
            catch (UnsupportedOperationException e) {
                if (SystemProperties.getJavaVendor().contains("IBM")) break block2;
                Assertions.fail((String)"This test should only throw UOE on IBM JDKs with broken UTF-16");
            }
        }
    }

    @Test
    void testUTF8WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, UTF_8);
    }

    @Test
    void testUTF8WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, UTF_8);
    }

    private void testWithBufferedWrite(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)writer)).setCharset(charsetName).get();){
            int length;
            for (int offset = 0; offset < expected.length; offset += length) {
                length = Math.min(this.random.nextInt(128), expected.length - offset);
                out.write(expected, offset, length);
            }
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
    }

    private void testWithSingleByteWrite(String testString, Charset charset) throws IOException {
        byte[] bytes = testString.getBytes(Charsets.toCharset((Charset)charset));
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, charset);){
            this.writeOneAtATime(bytes, out);
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
        writer = new StringWriter();
        out = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)writer)).setCharset(charset).get();
        try {
            this.writeOneAtATime(bytes, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
    }

    private void testWithSingleByteWrite(String testString, CharsetDecoder charsetDecoder) throws IOException {
        byte[] bytes = testString.getBytes(CharsetDecoders.toCharsetDecoder((CharsetDecoder)charsetDecoder).charset());
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetDecoder);){
            this.writeOneAtATime(bytes, out);
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
        writer = new StringWriter();
        out = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)writer)).setCharsetDecoder(charsetDecoder).get();
        try {
            this.writeOneAtATime(bytes, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
    }

    private void testWithSingleByteWrite(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(Charsets.toCharset((String)charsetName));
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);){
            this.writeOneAtATime(bytes, out);
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
        writer = new StringWriter();
        out = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)writer)).setCharset(charsetName).get();
        try {
            this.writeOneAtATime(bytes, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
    }

    @Test
    void testWriteImmediately() throws IOException {
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024, true);){
            out.write("abc".getBytes(StandardCharsets.US_ASCII));
            Assertions.assertEquals((Object)"abc", (Object)writer.toString());
        }
        out = ((WriterOutputStream.Builder)((WriterOutputStream.Builder)((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)writer)).setCharset("us-ascii").setBufferSize(1024)).setWriteImmediately(true).setOpenOptions(new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE})).get();
        try {
            out.write("abc".getBytes(StandardCharsets.US_ASCII));
            Assertions.assertEquals((Object)"abcabc", (Object)writer.toString());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void writeOneAtATime(byte[] bytes, WriterOutputStream out) throws IOException {
        for (byte b : bytes) {
            out.write((int)b);
        }
    }
}

