/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class StandardSerializerUnitTest
extends TestCase {
    public void testSimpleBackAndForth() throws Exception {
        StandardSerializer serializer = new StandardSerializer();
        String before = "adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231";
        String after = (String)serializer.deSerialize(serializer.serialize((Object)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231"), null);
        StandardSerializerUnitTest.assertEquals((String)"Before and after should be the same.", (String)"adsfdsafdsafdsafdsafdsafdsafdsagfdsafdsafdsfdsafdsafsa333 31231", (String)after);
    }

    public void testNullInput() throws Exception {
        StandardSerializer serializer = new StandardSerializer();
        Object before = null;
        byte[] serialized = serializer.serialize(before);
        String after = (String)serializer.deSerialize(serialized, null);
        StandardSerializerUnitTest.assertNull((String)"Should have nothing.", (Object)after);
    }

    public void testBigStringBackAndForth() throws Exception {
        StandardSerializer serializer = new StandardSerializer();
        String string = "This is my big string ABCDEFGH";
        StringBuilder sb = new StringBuilder();
        sb.append("This is my big string ABCDEFGH");
        for (int i = 0; i < 4; ++i) {
            sb.append(" " + i + sb.toString());
        }
        String before = sb.toString();
        String after = (String)serializer.deSerialize(serializer.serialize((Object)before), null);
        StandardSerializerUnitTest.assertEquals((String)"Before and after should be the same.", (String)before, (String)after);
    }
}

