/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs3.utils.net.HostNameUtil;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class UDPDiscoverySender
implements AutoCloseable {
    private static final Log log = LogManager.getLog(UDPDiscoverySender.class);
    private final MulticastSocket localSocket;
    private final InetAddress multicastAddress;
    private final int multicastPort;
    private final IElementSerializer serializer;

    @Deprecated
    public UDPDiscoverySender(String host, int port, int udpTTL) throws IOException {
        this(null, host, port, udpTTL, new StandardSerializer());
    }

    public UDPDiscoverySender(UDPDiscoveryAttributes udpDiscoveryAttributes, IElementSerializer serializer) throws IOException {
        this(udpDiscoveryAttributes.getUdpDiscoveryInterface(), udpDiscoveryAttributes.getUdpDiscoveryAddr(), udpDiscoveryAttributes.getUdpDiscoveryPort(), udpDiscoveryAttributes.getUdpTTL(), serializer);
    }

    public UDPDiscoverySender(String mcastInterface, String host, int port, int udpTTL, IElementSerializer serializer) throws IOException {
        try {
            log.debug("Constructing socket for sender on port [{0}]", port);
            this.localSocket = new MulticastSocket(port);
            if (udpTTL > 0) {
                log.debug("Setting datagram TTL to [{0}]", udpTTL);
                this.localSocket.setTimeToLive(udpTTL);
            }
            this.multicastAddress = InetAddress.getByName(host);
            NetworkInterface multicastInterface = null;
            multicastInterface = mcastInterface != null ? NetworkInterface.getByName(mcastInterface) : HostNameUtil.getMulticastNetworkInterface();
            if (multicastInterface != null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = multicastInterface::getDisplayName;
                log.info("Sending multicast via network interface {0}", supplierArray);
                this.localSocket.setNetworkInterface(multicastInterface);
            }
        }
        catch (IOException e) {
            log.error("Could not bind to multicast address [{0}]", host, e);
            throw e;
        }
        this.multicastPort = port;
        this.serializer = serializer;
    }

    @Override
    public void close() {
        if (this.localSocket != null && !this.localSocket.isClosed()) {
            this.localSocket.close();
        }
    }

    public void send(UDPDiscoveryMessage message) throws IOException {
        if (this.localSocket == null) {
            throw new IOException("Socket is null, cannot send message.");
        }
        if (this.localSocket.isClosed()) {
            throw new IOException("Socket is closed, cannot send message.");
        }
        log.debug("sending UDPDiscoveryMessage, address [{0}], port [{1}], message = {2}", this.multicastAddress, this.multicastPort, message);
        byte[] bytes = this.serializer.serialize(message);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.multicastAddress, this.multicastPort);
        log.debug("Sending DatagramPacket with {0} bytes to {1}:{2}", bytes.length, this.multicastAddress, this.multicastPort);
        this.localSocket.send(packet);
    }

    public void requestBroadcast() throws IOException {
        log.debug("sending requestBroadcast");
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(this.multicastAddress.getHostAddress());
        message.setPort(this.multicastPort);
        message.setRequesterId(CacheInfo.listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.REQUEST);
        this.send(message);
    }

    public void passiveBroadcast(String host, int port, ArrayList<String> cacheNames) throws IOException {
        this.passiveBroadcast(host, port, cacheNames, CacheInfo.listenerId);
    }

    protected void passiveBroadcast(String host, int port, ArrayList<String> cacheNames, long listenerId) throws IOException {
        log.debug("sending passiveBroadcast");
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.PASSIVE);
        this.send(message);
    }

    public void removeBroadcast(String host, int port, ArrayList<String> cacheNames) throws IOException {
        this.removeBroadcast(host, port, cacheNames, CacheInfo.listenerId);
    }

    protected void removeBroadcast(String host, int port, ArrayList<String> cacheNames, long listenerId) throws IOException {
        log.debug("sending removeBroadcast");
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.REMOVE);
        this.send(message);
    }
}

