/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.HsqlSetupTableUtil;
import org.hsqldb.jdbcDriver;

public class JDBCDiskCacheRemovalUnitTest
extends TestCase {
    private final String databaseName = "JCS_STORE_REMOVAL";

    public void setUp() {
        System.setProperty("DATABASE_NAME", "JCS_STORE_REMOVAL");
        JCS.setConfigFilename((String)"/TestJDBCDiskCacheRemoval.ccf");
    }

    public void testPartialKeyRemoval_Good() throws Exception {
        this.setupDatabase();
        String keyPart1 = "part1";
        String keyPart2 = "part2";
        String region = "testCache1";
        String data = "adfadsfasfddsafasasd";
        CacheAccess jcs = JCS.getInstance((String)"testCache1");
        jcs.put((Object)"part1:part2", (Object)"adfadsfasfddsafasasd");
        Thread.sleep(1000L);
        String resultBeforeRemove = (String)jcs.get((Object)"part1:part2");
        JDBCDiskCacheRemovalUnitTest.assertEquals((String)"Wrong result", (String)"adfadsfasfddsafasasd", (String)resultBeforeRemove);
        jcs.remove((Object)"part1:");
        String resultAfterRemove = (String)jcs.get((Object)"part1:part2");
        JDBCDiskCacheRemovalUnitTest.assertNull((String)"Should not have a result after removal.", (Object)resultAfterRemove);
    }

    private void setupDatabase() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        System.setProperty("hsqldb.cache_scale", "8");
        String rafroot = "target";
        Properties p = new Properties();
        String driver = p.getProperty("driver", "org.hsqldb.jdbcDriver");
        String url = p.getProperty("url", "jdbc:hsqldb:");
        String database = p.getProperty("database", "target/JDBCDiskCacheRemovalUnitTest");
        String user = p.getProperty("user", "sa");
        String password = p.getProperty("password", "");
        new jdbcDriver();
        Class.forName(driver).newInstance();
        Connection cConn = DriverManager.getConnection(url + database, user, password);
        HsqlSetupTableUtil.setupTABLE(cConn, "JCS_STORE_REMOVAL");
    }
}

