/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.commons.logging.simple.DecoratedSimpleLog;

public class DefaultConfigTestCase
extends TestCase {
    protected LogFactory factory;
    protected Log log;

    public static Test suite() throws Exception {
        Class<DefaultConfigTestCase> thisClass = DefaultConfigTestCase.class;
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", Test.class.getClassLoader());
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    protected void checkDecorated() {
        DefaultConfigTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        DefaultConfigTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.simple.DecoratedSimpleLog", (String)this.log.getClass().getName());
        DefaultConfigTestCase.assertFalse((boolean)this.log.isDebugEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isErrorEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isFatalEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isInfoEnabled());
        DefaultConfigTestCase.assertFalse((boolean)this.log.isTraceEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isWarnEnabled());
        DefaultConfigTestCase.assertEquals((int)3, (int)((SimpleLog)this.log).getLevel());
        DefaultConfigTestCase.assertEquals((String)"yyyy/MM/dd HH:mm:ss:SSS zzz", (String)((DecoratedSimpleLog)this.log).getDateTimeFormat());
        DefaultConfigTestCase.assertEquals((String)"DecoratedLogger", (String)((DecoratedSimpleLog)this.log).getLogName());
        DefaultConfigTestCase.assertFalse((boolean)((DecoratedSimpleLog)this.log).getShowDateTime());
        DefaultConfigTestCase.assertTrue((boolean)((DecoratedSimpleLog)this.log).getShowShortName());
    }

    protected void checkStandard() {
        DefaultConfigTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        DefaultConfigTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.SimpleLog", (String)this.log.getClass().getName());
        DefaultConfigTestCase.assertFalse((boolean)this.log.isDebugEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isErrorEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isFatalEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isInfoEnabled());
        DefaultConfigTestCase.assertFalse((boolean)this.log.isTraceEnabled());
        DefaultConfigTestCase.assertTrue((boolean)this.log.isWarnEnabled());
        DefaultConfigTestCase.assertEquals((int)3, (int)((SimpleLog)this.log).getLevel());
    }

    public void setProperties() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
        this.setProperties();
        this.setUpFactory();
        this.setUpLog("TestLogger");
    }

    protected void setUpDecorated(String name) {
        this.log = new DecoratedSimpleLog(name);
    }

    protected void setUpFactory() throws Exception {
        this.factory = LogFactory.getFactory();
    }

    protected void setUpLog(String name) throws Exception {
        this.log = LogFactory.getLog((String)name);
    }

    public void tearDown() {
        this.log = null;
        this.factory = null;
        LogFactory.releaseAll();
    }

    public void testPristineDecorated() {
        this.setUpDecorated("DecoratedLogger");
        this.checkDecorated();
    }

    public void testPristineFactory() {
        DefaultConfigTestCase.assertNotNull((String)"LogFactory exists", (Object)this.factory);
        DefaultConfigTestCase.assertEquals((String)"LogFactory class", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)this.factory.getClass().getName());
        String[] names = this.factory.getAttributeNames();
        DefaultConfigTestCase.assertNotNull((String)"Names exists", (Object)names);
        DefaultConfigTestCase.assertEquals((String)"Names empty", (int)0, (int)names.length);
    }

    public void testPristineLog() {
        this.checkStandard();
    }

    public void testSerializable() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.log);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            this.log = (Log)ois.readObject();
        }
        this.checkStandard();
    }
}

