/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.unix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.commons.net.chargen.CharGenTCPClient;
import org.apache.commons.net.chargen.CharGenUDPClient;

public final class chargen {
    public static void chargenTCP(String host) throws IOException {
        int lines = 100;
        CharGenTCPClient client = new CharGenTCPClient();
        client.setDefaultTimeout(60000);
        client.connect(host);
        try (BufferedReader chargenInput = new BufferedReader(new InputStreamReader(client.getInputStream(), Charset.defaultCharset()));){
            while (lines-- > 0) {
                String line = chargenInput.readLine();
                if (line == null) {
                    break;
                }
                System.out.println(line);
            }
        }
        client.disconnect();
    }

    public static void chargenUDP(String host) throws IOException {
        int packets = 50;
        InetAddress address = InetAddress.getByName(host);
        try (CharGenUDPClient client = new CharGenUDPClient();){
            client.open();
            client.setSoTimeout(Duration.ofSeconds(5L));
            while (packets-- > 0) {
                byte[] data;
                client.send(address);
                try {
                    data = client.receive();
                }
                catch (SocketException e) {
                    System.err.println("SocketException: Timed out and dropped packet");
                    continue;
                }
                catch (InterruptedIOException e) {
                    System.err.println("InterruptedIOException: Timed out and dropped packet");
                    continue;
                }
                System.out.write(data);
                System.out.flush();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                chargen.chargenTCP(args[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-udp")) {
            try {
                chargen.chargenUDP(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.err.println("Usage: chargen [-udp] <hostname>");
            System.exit(1);
        }
    }
}

