/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultPooledObject {
    @Test
    public void testGetIdleTimeMillis() throws Exception {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        AtomicBoolean negativeIdleTimeReturned = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 3);
        Runnable allocateAndDeallocateTask = () -> {
            for (int i1 = 0; i1 < 10000; ++i1) {
                if (dpo.getIdleDuration().isNegative() || dpo.getIdleTime().isNegative()) {
                    negativeIdleTimeReturned.set(true);
                    break;
                }
                if (!dpo.getIdleDuration().isNegative() && !dpo.getIdleTime().isNegative()) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
            dpo.allocate();
            for (int i2 = 0; i2 < 10000; ++i2) {
                if (!dpo.getIdleDuration().isNegative() && !dpo.getIdleTime().isNegative()) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
            dpo.deallocate();
        };
        Runnable getIdleTimeTask = () -> {
            for (int i = 0; i < 10000; ++i) {
                if (!dpo.getIdleDuration().isNegative() && !dpo.getIdleTime().isNegative()) continue;
                negativeIdleTimeReturned.set(true);
                break;
            }
        };
        double probabilityOfAllocationTask = 0.7;
        ArrayList futures = new ArrayList();
        for (int i = 1; i <= 10000; ++i) {
            Runnable runnable = Math.random() < 0.7 ? allocateAndDeallocateTask : getIdleTimeTask;
            futures.add(executor.submit(runnable));
        }
        for (Future future : futures) {
            future.get();
        }
        Assertions.assertFalse((boolean)negativeIdleTimeReturned.get(), (String)"DefaultPooledObject.getIdleTimeMillis() returned a negative value");
    }

    @Test
    public void testInitialStateActiveDuration() throws InterruptedException {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Thread.sleep(200L);
        Assertions.assertFalse((boolean)dpo.getActiveDuration().isNegative());
        Assertions.assertFalse((boolean)dpo.getActiveDuration().isZero());
        Assertions.assertTrue((Duration.ZERO.compareTo(Duration.ZERO.plusNanos(1L)) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getActiveDuration().compareTo(dpo.getIdleDuration()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getActiveDuration().toMillis() <= dpo.getActiveTimeMillis() ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getActiveDuration().compareTo(dpo.getActiveTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getActiveDuration().compareTo(dpo.getIdleTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getActiveDuration().toMillis() <= dpo.getIdleTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testInitialStateCreateInstant() {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Assertions.assertEquals((Object)dpo.getCreateInstant(), (Object)dpo.getLastBorrowInstant());
        Assertions.assertEquals((Object)dpo.getCreateInstant(), (Object)dpo.getLastReturnInstant());
        Assertions.assertEquals((Object)dpo.getCreateInstant(), (Object)dpo.getLastUsedInstant());
        Assertions.assertEquals((long)dpo.getCreateInstant().toEpochMilli(), (long)dpo.getCreateTime());
        Assertions.assertEquals((long)dpo.getCreateTime(), (long)dpo.getLastBorrowTime());
        Assertions.assertEquals((long)dpo.getCreateTime(), (long)dpo.getLastReturnTime());
        Assertions.assertEquals((long)dpo.getCreateTime(), (long)dpo.getLastUsedTime());
    }

    @Test
    public void testInitialStateDuration() throws InterruptedException {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Duration duration1 = dpo.getFullDuration();
        Assertions.assertNotNull((Object)duration1);
        Assertions.assertFalse((boolean)duration1.isNegative());
        Thread.sleep(100L);
        Duration duration2 = dpo.getFullDuration();
        Assertions.assertNotNull((Object)duration2);
        Assertions.assertFalse((boolean)duration2.isNegative());
        Assertions.assertTrue((duration1.compareTo(duration2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInitialStateIdleDuration() throws InterruptedException {
        DefaultPooledObject dpo = new DefaultPooledObject(new Object());
        Thread.sleep(200L);
        Assertions.assertFalse((boolean)dpo.getIdleDuration().isNegative());
        Assertions.assertFalse((boolean)dpo.getIdleDuration().isZero());
        Assertions.assertTrue((dpo.getIdleDuration().compareTo(dpo.getActiveDuration()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getIdleDuration().compareTo(dpo.getActiveTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((dpo.getIdleDuration().toMillis() <= dpo.getActiveTimeMillis() ? 1 : 0) != 0);
    }
}

