/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import org.apache.commons.text.StrMatcher;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class StrMatcherTest {
    private static final char[] BUFFER1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] BUFFER2 = "abcdef".toCharArray();

    @Test
    public void testCommaMatcher() {
        StrMatcher matcher = StrMatcher.commaMatcher();
        Assertions.assertThat((Object)StrMatcher.commaMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 1)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2)).isEqualTo(0);
    }

    @Test
    public void testTabMatcher() {
        StrMatcher matcher = StrMatcher.tabMatcher();
        Assertions.assertThat((Object)StrMatcher.tabMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4)).isEqualTo(0);
    }

    @Test
    public void testSpaceMatcher() {
        StrMatcher matcher = StrMatcher.spaceMatcher();
        Assertions.assertThat((Object)StrMatcher.spaceMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6)).isEqualTo(0);
    }

    @Test
    public void testSplitMatcher() {
        StrMatcher matcher = StrMatcher.splitMatcher();
        Assertions.assertThat((Object)StrMatcher.splitMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 7)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 8)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 9)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10)).isEqualTo(0);
    }

    @Test
    public void testTrimMatcher() {
        StrMatcher matcher = StrMatcher.trimMatcher();
        Assertions.assertThat((Object)StrMatcher.trimMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 7)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 8)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 9)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10)).isEqualTo(1);
    }

    @Test
    public void testSingleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.singleQuoteMatcher();
        Assertions.assertThat((Object)StrMatcher.singleQuoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12)).isEqualTo(0);
    }

    @Test
    public void testDoubleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.doubleQuoteMatcher();
        Assertions.assertThat((Object)StrMatcher.doubleQuoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12)).isEqualTo(1);
    }

    @Test
    public void testQuoteMatcher() {
        StrMatcher matcher = StrMatcher.quoteMatcher();
        Assertions.assertThat((Object)StrMatcher.quoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12)).isEqualTo(1);
    }

    @Test
    public void testNoneMatcher() {
        StrMatcher matcher = StrMatcher.noneMatcher();
        Assertions.assertThat((Object)StrMatcher.noneMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 7)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 8)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 9)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12)).isEqualTo(0);
    }

    @Test
    public void testCharMatcher_char() {
        StrMatcher matcher = StrMatcher.charMatcher((char)'c');
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5)).isEqualTo(0);
    }

    @Test
    public void testCharSetMatcher_String() {
        StrMatcher matcher = StrMatcher.charSetMatcher((String)"ace");
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5)).isEqualTo(0);
        Assertions.assertThat((Object)StrMatcher.charSetMatcher((String)"")).isSameAs((Object)StrMatcher.noneMatcher());
        Assertions.assertThat((Object)StrMatcher.charSetMatcher((String)null)).isSameAs((Object)StrMatcher.noneMatcher());
        Assertions.assertThat((boolean)(StrMatcher.charSetMatcher((String)"a") instanceof StrMatcher.CharMatcher)).isTrue();
    }

    @Test
    public void testCharSetMatcher_charArray() {
        StrMatcher matcher = StrMatcher.charSetMatcher((char[])"ace".toCharArray());
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5)).isEqualTo(0);
        Assertions.assertThat((Object)StrMatcher.charSetMatcher((char[])new char[0])).isSameAs((Object)StrMatcher.noneMatcher());
        Assertions.assertThat((Object)StrMatcher.charSetMatcher((char[])null)).isSameAs((Object)StrMatcher.noneMatcher());
        Assertions.assertThat((boolean)(StrMatcher.charSetMatcher((char[])"a".toCharArray()) instanceof StrMatcher.CharMatcher)).isTrue();
    }

    @Test
    public void testStringMatcher_String() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5)).isEqualTo(0);
        Assertions.assertThat((Object)StrMatcher.stringMatcher((String)"")).isSameAs((Object)StrMatcher.noneMatcher());
        Assertions.assertThat((Object)StrMatcher.stringMatcher((String)null)).isSameAs((Object)StrMatcher.noneMatcher());
    }

    @Test
    public void testMatcherIndices() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 1, BUFFER2.length)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, 3)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, 2)).isEqualTo(0);
    }
}

