/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.Arrays;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class MersenneTwister
extends IntProvider {
    private static final long INT_MASK_LONG = 0xFFFFFFFFL;
    private static final long UPPER_MASK_LONG = 0x80000000L;
    private static final long LOWER_MASK_LONG = Integer.MAX_VALUE;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01 = new int[]{0, -1727483681};
    private final int[] mt = new int[624];
    private int mti;

    public MersenneTwister(int[] seed) {
        this.setSeedInternal(seed);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] s = Arrays.copyOf(this.mt, 625);
        s[624] = this.mti;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 2500);
        int[] tmp = NumberFactory.makeIntArray(c[0]);
        System.arraycopy(tmp, 0, this.mt, 0, 624);
        this.mti = tmp[624];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(int[] seed) {
        MersenneTwister.fillStateMersenneTwister(this.mt, seed);
        this.mti = 624;
    }

    private static void fillStateMersenneTwister(int[] state, int[] inputSeed) {
        int[] seed = inputSeed.length == 0 ? new int[1] : inputSeed;
        MersenneTwister.initializeState(state);
        int nextIndex = MersenneTwister.mixSeedAndState(state, seed);
        MersenneTwister.mixState(state, nextIndex);
        state[0] = Integer.MIN_VALUE;
    }

    private static void initializeState(int[] state) {
        long mt = 19650218L;
        state[0] = (int)mt;
        for (int i = 1; i < state.length; ++i) {
            mt = 1812433253L * (mt ^ mt >> 30) + (long)i & 0xFFFFFFFFL;
            state[i] = (int)mt;
        }
    }

    private static int mixSeedAndState(int[] state, int[] seed) {
        int stateSize = state.length;
        int i = 1;
        int j = 0;
        for (int k = Math.max(stateSize, seed.length); k > 0; --k) {
            long a = (long)state[i] & Integer.MAX_VALUE | (state[i] < 0 ? 0x80000000L : 0L);
            long b = (long)state[i - 1] & Integer.MAX_VALUE | (state[i - 1] < 0 ? 0x80000000L : 0L);
            long c = (a ^ (b ^ b >> 30) * 1664525L) + (long)seed[j] + (long)j;
            state[i] = (int)(c & 0xFFFFFFFFL);
            ++j;
            if (++i >= stateSize) {
                state[0] = state[stateSize - 1];
                i = 1;
            }
            if (j < seed.length) continue;
            j = 0;
        }
        return i;
    }

    private static void mixState(int[] state, int startIndex) {
        int stateSize = state.length;
        int i = startIndex;
        for (int k = stateSize - 1; k > 0; --k) {
            long a = (long)state[i] & Integer.MAX_VALUE | (state[i] < 0 ? 0x80000000L : 0L);
            long b = (long)state[i - 1] & Integer.MAX_VALUE | (state[i - 1] < 0 ? 0x80000000L : 0L);
            long c = (a ^ (b ^ b >> 30) * 1566083941L) - (long)i;
            state[i] = (int)(c & 0xFFFFFFFFL);
            if (++i < stateSize) continue;
            state[0] = state[stateSize - 1];
            i = 1;
        }
    }

    @Override
    public int next() {
        int y;
        if (this.mti >= 624) {
            int mtCurr;
            int k;
            int mtNext = this.mt[0];
            for (k = 0; k < 227; ++k) {
                mtCurr = mtNext;
                mtNext = this.mt[k + 1];
                y = mtCurr & Integer.MIN_VALUE | mtNext & Integer.MAX_VALUE;
                this.mt[k] = this.mt[k + 397] ^ y >>> 1 ^ MAG01[y & 1];
            }
            for (k = 227; k < 623; ++k) {
                mtCurr = mtNext;
                mtNext = this.mt[k + 1];
                y = mtCurr & Integer.MIN_VALUE | mtNext & Integer.MAX_VALUE;
                this.mt[k] = this.mt[k + -227] ^ y >>> 1 ^ MAG01[y & 1];
            }
            y = mtNext & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ MAG01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }
}

