/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class LongProvider
extends BaseProvider
implements RandomLongSource {
    private static final long EMPTY_BOOL_SOURCE = 1L;
    private static final long EMPTY_INT_SOURCE = -1L;
    private long booleanSource = 1L;
    private long intSource = -1L;

    public LongProvider() {
    }

    protected LongProvider(LongProvider source) {
        this.booleanSource = source.booleanSource;
        this.intSource = source.intSource;
    }

    protected void resetCachedState() {
        this.booleanSource = 1L;
        this.intSource = -1L;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] state = new long[]{this.booleanSource, this.intSource};
        return this.composeStateInternal(NumberFactory.makeByteArray(state), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        long[] state = NumberFactory.makeLongArray(c[0]);
        this.booleanSource = state[0];
        this.intSource = state[1];
        super.setStateInternal(c[1]);
    }

    public long nextLong() {
        return this.next();
    }

    public int nextInt() {
        long bits = this.intSource;
        if (bits < 0L) {
            bits = this.next();
            this.intSource = bits >>> 32;
            return (int)bits;
        }
        this.intSource = -1L;
        return (int)bits;
    }

    public boolean nextBoolean() {
        long bits = this.booleanSource;
        if (bits == 1L) {
            bits = this.next();
            this.booleanSource = Long.MIN_VALUE | bits >>> 1;
            return (bits & 1L) == 1L;
        }
        this.booleanSource = bits >>> 1;
        return (bits & 1L) == 1L;
    }
}

