/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.distribution.GuideTableDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class DiscreteProbabilityCollectionSampler<T>
implements SharedStateObjectSampler<T> {
    private static final String EMPTY_COLLECTION = "Empty collection";
    private final List<T> items;
    private final SharedStateDiscreteSampler sampler;

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, Map<T, Double> collection) {
        this(DiscreteProbabilityCollectionSampler.toList(collection), DiscreteProbabilityCollectionSampler.createSampler(rng, DiscreteProbabilityCollectionSampler.toProbabilities(collection)));
    }

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, List<T> collection, double[] probabilities) {
        this(DiscreteProbabilityCollectionSampler.copyList(collection), DiscreteProbabilityCollectionSampler.createSampler(rng, collection, probabilities));
    }

    private DiscreteProbabilityCollectionSampler(List<T> items, SharedStateDiscreteSampler sampler) {
        this.items = items;
        this.sampler = sampler;
    }

    @Override
    public T sample() {
        return this.items.get(this.sampler.sample());
    }

    @Override
    public DiscreteProbabilityCollectionSampler<T> withUniformRandomProvider(UniformRandomProvider rng) {
        return new DiscreteProbabilityCollectionSampler<T>(this.items, (SharedStateDiscreteSampler)this.sampler.withUniformRandomProvider(rng));
    }

    private static SharedStateDiscreteSampler createSampler(UniformRandomProvider rng, double[] probabilities) {
        return GuideTableDiscreteSampler.of(rng, probabilities);
    }

    private static <T> SharedStateDiscreteSampler createSampler(UniformRandomProvider rng, List<T> collection, double[] probabilities) {
        if (probabilities.length != collection.size()) {
            throw new IllegalArgumentException("Size mismatch: " + probabilities.length + " != " + collection.size());
        }
        return GuideTableDiscreteSampler.of(rng, probabilities);
    }

    private static <T> List<T> toList(Map<T, Double> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(EMPTY_COLLECTION);
        }
        return new ArrayList<T>(collection.keySet());
    }

    private static <T> double[] toProbabilities(Map<T, Double> collection) {
        int size = collection.size();
        double[] probabilities = new double[size];
        int count = 0;
        for (Double e : collection.values()) {
            double probability = e;
            if (probability < 0.0 || Double.isInfinite(probability) || Double.isNaN(probability)) {
                throw new IllegalArgumentException("Invalid probability: " + probability);
            }
            probabilities[count++] = probability;
        }
        return probabilities;
    }

    private static <T> List<T> copyList(List<T> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(EMPTY_COLLECTION);
        }
        return new ArrayList<T>(collection);
    }
}

