/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.InputStream;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ExtensionTest {
    protected static final String FORM_KEY = "nameForm";
    protected static final String FORM_KEY2 = "nameForm2";
    protected static final String CHECK_MSG_KEY = "nameForm.lastname.displayname";
    protected static final String ACTION = "required";
    private ValidatorResources resources;

    ExtensionTest() {
    }

    @BeforeEach
    protected void setUp() throws Exception {
        try (InputStream in = this.getClass().getResourceAsStream("ExtensionTest-config.xml");){
            this.resources = new ValidatorResources(in);
        }
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    void testOrder() {
        Form form = this.resources.getForm(ValidatorResources.defaultLocale, FORM_KEY);
        Form form2 = this.resources.getForm(ValidatorResources.defaultLocale, FORM_KEY2);
        Assertions.assertNotNull((Object)form, (String)"nameForm is null.");
        Assertions.assertEquals((int)2, (int)form.getFields().size(), (String)"There should only be 2 fields in nameForm");
        Assertions.assertNotNull((Object)form2, (String)"nameForm2 is null.");
        Assertions.assertEquals((int)2, (int)form2.getFields().size(), (String)"There should only be 2 fields in nameForm2");
        Field fieldFirstName = (Field)form.getFields().get(0);
        Field fieldLastName = (Field)form.getFields().get(1);
        Assertions.assertEquals((Object)"firstName", (Object)fieldFirstName.getKey(), (String)"firstName in nameForm should be the first in the list");
        Assertions.assertEquals((Object)"lastName", (Object)fieldLastName.getKey(), (String)"lastName in nameForm should be the first in the list");
        fieldLastName = (Field)form2.getFields().get(0);
        fieldFirstName = (Field)form2.getFields().get(1);
        Assertions.assertEquals((Object)"firstName", (Object)fieldFirstName.getKey(), (String)"firstName in nameForm2 should be the first in the list");
        Assertions.assertEquals((Object)"lastName", (Object)fieldLastName.getKey(), (String)"lastName in nameForm2 should be the first in the list");
    }

    @Test
    void testOverrideRule() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY2);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertEquals((Object)CHECK_MSG_KEY, (Object)firstNameResult.field.getArg(0).getKey(), (String)"First Name ValidatorResult for the 'required' action should have 'nameForm.lastname.displayname as a key.");
        Assertions.assertNull((Object)lastNameResult, (String)"Last Name ValidatorResult should be null.");
    }

    @Test
    void testRequired() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)firstNameResult.isValid(ACTION), (String)"First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)lastNameResult.isValid(ACTION), (String)"Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    void testRequiredFirstName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION), (String)"First Name ValidatorResult for the 'required' action should have passed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)lastNameResult.isValid(ACTION), (String)"Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    void testRequiredFirstNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)firstNameResult.isValid(ACTION), (String)"First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)lastNameResult.isValid(ACTION), (String)"Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    void testRequiredLastName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)firstNameResult.isValid(ACTION), (String)"First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)lastNameResult.isValid(ACTION), (String)"Last Name ValidatorResult for the 'required' action should have passed.");
    }

    @Test
    void testRequiredLastNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)firstNameResult.isValid(ACTION), (String)"First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertFalse((boolean)lastNameResult.isValid(ACTION), (String)"Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    void testRequiredName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION), (String)"First Name ValidatorResult for the 'required' action should have passed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"Last Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)lastNameResult.isValid(ACTION), (String)"Last Name ValidatorResult for the 'required' action should have passed.");
    }
}

